/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.GUIStatus;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class AbstractGUI {
    public static Map<Player, GUIStatus> playerList = new HashMap<Player, GUIStatus>();
    private static boolean inClickCooldown = false;
    protected Player player;

    public AbstractGUI(Player owner) {
        this.player = owner;
    }

    protected abstract void constructGUI();

    public boolean canOpenGUI(boolean reopen) {
        if (ConfigManager.configManager.getLong("menu.cooldown.reopen", -1L) <= 0L) {
            return true;
        }
        if (playerList.containsKey(this.player)) {
            if (!reopen || playerList.get(this.player) == GUIStatus.ACTION_OPEN_MENU) {
                return false;
            }
        } else {
            playerList.put(this.player, GUIStatus.CAN_REOPEN);
            return true;
        }
        playerList.replace(this.player, GUIStatus.ACTION_OPEN_MENU);
        return true;
    }

    public void removeOpenGUIStatus() {
        long time = ConfigManager.configManager.getLong("menu.cooldown.reopen", 3L);
        if (playerList.containsKey(this.player) && playerList.get(this.player) != GUIStatus.ALREADY_IN_COOLDOWN) {
            playerList.replace(this.player, GUIStatus.ALREADY_IN_COOLDOWN);
            if (UltimateShop.isFolia) {
                Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)UltimateShop.instance, task -> playerList.remove(this.player), time);
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)UltimateShop.instance, () -> playerList.remove(this.player), time);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void addCooldown() {
        long setValue = ConfigManager.configManager.getLong("menu.cooldown.click", 5L);
        if (!inClickCooldown && setValue > 0L) {
            inClickCooldown = true;
            if (UltimateShop.isFolia) {
                Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)UltimateShop.instance, task -> {
                    inClickCooldown = false;
                }, setValue);
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)UltimateShop.instance, () -> {
                inClickCooldown = false;
            }, setValue);
        }
    }

    public boolean getCooldown() {
        return inClickCooldown;
    }
}

