/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.form;

import cn.superiormc.ultimateshop.gui.FormGUI;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.ItemUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.Iterator;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;

public class FormCommonGUI
extends FormGUI {
    private ObjectMenu commonMenu = null;
    private final String fileName;
    private final boolean bypass;

    public FormCommonGUI(Player owner, String fileName, boolean bypass) {
        super(owner);
        this.fileName = fileName;
        this.bypass = bypass;
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        this.commonMenu = ObjectMenu.commonMenus.get(this.fileName);
        if (this.commonMenu == null || this.commonMenu.menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(this.player, "error.menu-not-found", "menu", this.fileName);
            return;
        }
        if (!this.bypass && !this.commonMenu.getCondition().getBoolean(this.player.getPlayer())) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.fileName);
            return;
        }
        this.menuButtons = this.commonMenu.getMenu();
        SimpleForm.Builder tempVal2 = SimpleForm.builder();
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            AbstractButton button = (AbstractButton)this.menuButtons.get(slot);
            ItemStack displayItem = button.getDisplayItem(this.player, 1);
            if (ItemUtil.getItemNameWithoutVanilla(displayItem).trim().isEmpty() || button.getButtonConfig().getBoolean("bedrock.hide", false)) continue;
            String icon = button.getButtonConfig().getString("bedrock.icon", button.getButtonConfig().getString("bedrock-icon"));
            String tempVal3 = TextUtil.parse(ItemUtil.getItemName(displayItem), this.player);
            ButtonComponent tempVal1 = null;
            if (icon != null && icon.split(";;").length == 2) {
                String type = icon.split(";;")[0].toLowerCase();
                if (type.equals("url")) {
                    tempVal1 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.URL, (String)icon.split(";;")[1]);
                } else if (type.equals("path")) {
                    tempVal1 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.PATH, (String)icon.split(";;")[1]);
                }
            } else {
                tempVal1 = ButtonComponent.of((String)tempVal3);
            }
            if (tempVal1 != null) {
                tempVal2.button(tempVal1);
            }
            this.menuItems.put(tempVal1, slot);
        }
        tempVal2.title(TextUtil.parse(this.player, this.commonMenu.getString("title", "Shop")));
        tempVal2.validResultHandler(response -> {
            ((AbstractButton)this.menuButtons.get(this.menuItems.get(response.clickedButton()))).clickEvent(ClickType.LEFT, this.player);
            this.removeOpenGUIStatus();
        });
        this.form = tempVal2.build();
    }

    public ObjectMenu getMenu() {
        return this.commonMenu;
    }
}

