/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.form;

import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.gui.FormGUI;
import cn.superiormc.ultimateshop.gui.form.FormBuyOrSellGUI;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.GUI.ModifyDisplayItem;
import cn.superiormc.ultimateshop.methods.GUI.OpenGUI;
import cn.superiormc.ultimateshop.methods.Product.BuyProductMethod;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.menus.ObjectMoreMenu;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;

public class FormInfoGUI
extends FormGUI {
    private final ObjectItem item;
    private final ObjectMoreMenu menu;
    private String amount;

    public FormInfoGUI(Player owner, ObjectItem item) {
        super(owner);
        this.item = item;
        this.menu = ObjectMoreMenu.moreMenus.get(item);
        this.amount = "1";
        this.constructGUI();
    }

    public FormInfoGUI(Player owner, ObjectItem item, String amount) {
        super(owner);
        this.item = item;
        this.menu = ObjectMoreMenu.moreMenus.get(item);
        this.amount = amount;
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        PlayerCache tempVal1 = CacheManager.cacheManager.getPlayerCache(this.player.getPlayer());
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.player-not-found", "player", this.player.getName());
            return;
        }
        SimpleForm.Builder tempVal2 = SimpleForm.builder();
        tempVal2.title(TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.title", new String[0])).replace("{item-name}", this.item.getDisplayName(this.getPlayer().getPlayer())));
        ArrayList<String> content = new ArrayList<String>();
        if (this.item.getDisplayItem(this.player).hasItemMeta() && this.item.getDisplayItem(this.player).getItemMeta().hasLore()) {
            content.addAll(this.item.getDisplayItem(this.player).getItemMeta().getLore());
            content.add(" ");
        }
        content.addAll(ModifyDisplayItem.getModifiedLore(this.player.getPlayer(), this.getAmount(), this.item, false, true, "general"));
        tempVal2.content(this.bedrockTransfer(content));
        ButtonComponent buy = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.buy", new String[0])).replace("{item-name}", this.item.getDisplayName(this.getPlayer().getPlayer())));
        ButtonComponent sell = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.sell", new String[0])).replace("{item-name}", this.item.getDisplayName(this.getPlayer().getPlayer())));
        ButtonComponent buyMore = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.buy-more", new String[0])).replace("{item-name}", this.item.getDisplayName(this.getPlayer().getPlayer())));
        if (!this.item.getBuyPrice().empty) {
            tempVal2.button(buy);
        }
        if (!this.item.getSellPrice().empty) {
            tempVal2.button(sell);
        }
        if (this.item.getBuyMore() && ConfigManager.configManager.containsClickAction("select-amount")) {
            tempVal2.button(buyMore);
        }
        tempVal2.validResultHandler(response -> {
            this.removeOpenGUIStatus();
            if (response.clickedButton().equals((Object)buy)) {
                this.doThing(true);
            } else if (response.clickedButton().equals((Object)sell)) {
                this.doThing(false);
            } else if (response.clickedButton().equals((Object)buyMore)) {
                FormBuyOrSellGUI buyOrSellGUI = new FormBuyOrSellGUI(this.player, this.item);
                buyOrSellGUI.openGUI(true);
            }
        });
        this.form = tempVal2.build();
    }

    private String bedrockTransfer(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public ObjectItem getItem() {
        return this.item;
    }

    public void doThing(boolean buyOrSell) {
        this.removeOpenGUIStatus();
        if (this.amount == null) {
            return;
        }
        boolean b = ConfigManager.configManager.getBoolean("placeholder.click.enabled");
        if (!buyOrSell && this.amount.equals("all")) {
            if (!this.item.getSellPrice().empty) {
                SellProductMethod.startSell(this.item.getShop(), this.item.getProduct(), this.player.getPlayer(), !b, false, true, this.menu.getSection().getInt("max-amount", 64));
            }
            return;
        }
        if (buyOrSell) {
            if (!this.item.getBuyPrice().empty) {
                BuyProductMethod.startBuy(this.item.getShop(), this.item.getProduct(), this.player.getPlayer(), !b, false, this.getAmount());
            }
        } else if (!this.item.getSellPrice().empty) {
            SellProductMethod.startSell(this.item.getShop(), this.item.getProduct(), this.player.getPlayer(), !b, false, this.getAmount());
        }
        if (ConfigManager.configManager.getBoolean("menu.bedrock.not-auto-close")) {
            OpenGUI.openShopGUI(this.player, this.item.getShopObject(), true, true);
        }
    }

    public int getAmount() {
        int realAmount;
        try {
            realAmount = Integer.parseInt(this.amount);
            if (realAmount < 1) {
                realAmount = 1;
            } else if (realAmount > this.menu.getSection().getInt("max-amount", 64)) {
                realAmount = this.menu.getSection().getInt("max-amount", 64);
            }
        }
        catch (Throwable e) {
            realAmount = 1;
        }
        return realAmount;
    }
}

