/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.form;

import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.gui.FormGUI;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.ItemUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;

public class FormShopGUI
extends FormGUI {
    private final ObjectShop shop;
    private final boolean bypass;

    public FormShopGUI(Player owner, ObjectShop shop, boolean bypass) {
        super(owner);
        this.shop = shop;
        this.bypass = bypass;
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        AbstractButton button;
        int slot;
        PlayerCache tempVal1 = CacheManager.cacheManager.getPlayerCache(this.player.getPlayer());
        ServerCache tempVal2 = ServerCache.serverCache;
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.player-not-found", "player", this.player.getName());
            return;
        }
        if (this.shop.getShopMenuObject() == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.shop-does-not-have-menu", "shop", this.shop.getShopName());
            return;
        }
        if (this.shop.getShopMenuObject().menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.shop-menu-not-found", "shop", this.shop.getShopName(), "menu", this.shop.getShopMenu());
            return;
        }
        if (!this.bypass && !this.shop.getShopMenuObject().getCondition().getBoolean(this.player.getPlayer())) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.shop.getShopMenu());
            return;
        }
        for (ObjectItem tempVal5 : this.shop.getProductList()) {
            ObjectUseTimesCache tempVal4;
            ObjectUseTimesCache tempVal3 = tempVal1.getUseTimesCache().get(tempVal5);
            if (tempVal3 != null && tempVal3.getBuyRefreshTime() != null && tempVal3.getBuyRefreshTime().isBefore(LocalDateTime.now())) {
                if (ConfigManager.configManager.getBoolean("debug")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset player buy data by GUI open check!");
                }
                tempVal1.getUseTimesCache().get(tempVal5).setBuyUseTimes(0);
                tempVal1.getUseTimesCache().get(tempVal5).setLastBuyTime(null);
            }
            if (tempVal3 != null && tempVal3.getSellRefreshTime() != null && tempVal3.getSellRefreshTime().isBefore(LocalDateTime.now())) {
                if (ConfigManager.configManager.getBoolean("debug")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset player sell data by GUI open check!");
                }
                tempVal1.getUseTimesCache().get(tempVal5).setSellUseTimes(0);
                tempVal1.getUseTimesCache().get(tempVal5).setLastSellTime(null);
            }
            if ((tempVal4 = tempVal2.getUseTimesCache().get(tempVal5)) != null && tempVal4.getBuyRefreshTime() != null && tempVal4.getBuyRefreshTime().isBefore(LocalDateTime.now())) {
                if (ConfigManager.configManager.getBoolean("debug")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset server buy data by GUI open check!");
                }
                tempVal2.getUseTimesCache().get(tempVal5).setBuyUseTimes(0);
                tempVal2.getUseTimesCache().get(tempVal5).setLastBuyTime(null);
            }
            if (tempVal4 == null || tempVal4.getSellRefreshTime() == null || !tempVal4.getSellRefreshTime().isBefore(LocalDateTime.now())) continue;
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset server sell data by GUI open check!");
            }
            tempVal2.getUseTimesCache().get(tempVal5).setSellUseTimes(0);
            tempVal2.getUseTimesCache().get(tempVal5).setLastSellTime(null);
        }
        this.menuButtons = this.shop.getShopMenuObject().getMenu();
        if (ConfigManager.configManager.getBoolean("debug")) {
            for (Integer i : this.menuButtons.keySet()) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fMenu Buttons: " + this.menuButtons.get(i));
            }
        }
        SimpleForm.Builder tempVal5 = SimpleForm.builder();
        LinkedHashMap<Integer, AbstractButton> tempVal8 = new LinkedHashMap<Integer, AbstractButton>();
        LinkedHashMap<Integer, AbstractButton> tempVal7 = new LinkedHashMap<Integer, AbstractButton>();
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            button = (AbstractButton)this.menuButtons.get(slot);
            if (button instanceof ObjectItem) {
                tempVal8.put(slot, button);
                continue;
            }
            tempVal7.put(slot, button);
        }
        tempVal8.putAll(tempVal7);
        iterator = tempVal8.keySet().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            button = (AbstractButton)tempVal8.get(slot);
            ItemStack displayItem = button.getDisplayItem(this.player, 1);
            if (ItemUtil.getItemNameWithoutVanilla(displayItem).trim().isEmpty() || button.getButtonConfig().getBoolean("bedrock.hide", false)) continue;
            String tempVal3 = TextUtil.parse(ItemUtil.getItemName(displayItem), this.player);
            String icon = button.getButtonConfig().getString("bedrock.icon", button.getButtonConfig().getString("bedrock-icon"));
            ButtonComponent tempVal6 = null;
            if (icon != null && icon.split(";;").length == 2) {
                String type = icon.split(";;")[0].toLowerCase();
                if (type.equals("url")) {
                    tempVal6 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.URL, (String)icon.split(";;")[1]);
                } else if (type.equals("path")) {
                    tempVal6 = ButtonComponent.of((String)tempVal3, (FormImage.Type)FormImage.Type.PATH, (String)icon.split(";;")[1]);
                }
            } else {
                tempVal6 = ButtonComponent.of((String)tempVal3);
            }
            if (tempVal6 != null) {
                tempVal5.button(tempVal6);
            }
            this.menuItems.put(tempVal6, slot);
        }
        tempVal5.title(TextUtil.parse(this.player, this.shop.getShopMenuObject().getString("title", this.shop.getShopDisplayName()).replace("{shop-name}", this.shop.getShopDisplayName())));
        tempVal5.validResultHandler(response -> {
            this.removeOpenGUIStatus();
            ((AbstractButton)this.menuButtons.get(this.menuItems.get(response.clickedButton()))).clickEvent(ClickType.LEFT, this.player);
        });
        this.form = tempVal5.build();
    }

    public ObjectMenu getMenu() {
        return this.shop.getShopMenuObject();
    }
}

