/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.inv;

import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.PaperUtil;
import java.util.Iterator;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CommonGUI
extends InvGUI {
    private ObjectMenu commonMenu = null;
    private final String fileName;
    private final boolean bypass;

    public CommonGUI(Player owner, String fileName, boolean bypass) {
        super(owner);
        this.fileName = fileName;
        this.bypass = bypass;
    }

    @Override
    protected void constructGUI() {
        this.commonMenu = ObjectMenu.commonMenus.get(this.fileName);
        if (this.commonMenu == null || this.commonMenu.menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(this.player, "error.menu-not-found", "menu", this.fileName);
            return;
        }
        if (!this.bypass && !this.commonMenu.getCondition().getBoolean(this.player.getPlayer())) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.fileName);
            return;
        }
        this.menuButtons = this.commonMenu.getMenu();
        this.menuItems = this.getMenuItems(this.player.getPlayer());
        if (Objects.isNull(this.inv)) {
            this.inv = PaperUtil.createNewInv(this.player, this.commonMenu.getInt("size", 54), this.commonMenu.getString("title", "Shop"));
        }
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        if (this.menuButtons.get(slot) == null) {
            return true;
        }
        ((AbstractButton)this.menuButtons.get(slot)).clickEvent(type, this.player.getPlayer());
        if (ConfigManager.configManager.getBoolean("menu.shop.click-update")) {
            this.constructGUI();
        } else {
            this.menuItems.put(slot, this.getMenuItem(this.player, slot));
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
        return true;
    }

    @Override
    public ObjectMenu getMenu() {
        return this.commonMenu;
    }
}

