/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.inv;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.PaperUtil;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ShopGUI
extends InvGUI {
    private final ObjectShop shop;
    private final boolean bypass;

    public ShopGUI(Player owner, ObjectShop shop, boolean bypass) {
        super(owner);
        this.shop = shop;
        this.bypass = bypass;
    }

    @Override
    public void openGUI(boolean reopen) {
        super.openGUI(reopen);
        if (!super.canOpenGUI(reopen)) {
            return;
        }
        if (ConfigManager.configManager.getBoolean("menu.shop.update")) {
            this.runTask = new BukkitRunnable(){

                public void run() {
                    ShopGUI.this.constructGUI();
                }
            };
            this.runTask.runTaskTimer((Plugin)UltimateShop.instance, 20L, 20L);
        }
    }

    @Override
    protected void constructGUI() {
        PlayerCache tempVal1 = CacheManager.cacheManager.getPlayerCache(this.player.getPlayer());
        ServerCache tempVal2 = ServerCache.serverCache;
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.player-not-found", "player", this.player.getName());
            return;
        }
        if (this.shop.getShopMenuObject() == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.shop-does-not-have-menu", "shop", this.shop.getShopName());
            return;
        }
        if (this.shop.getShopMenuObject().menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.shop-menu-not-found", "shop", this.shop.getShopName(), "menu", this.shop.getShopMenu());
            return;
        }
        if (!this.bypass && !this.shop.getShopMenuObject().getCondition().getBoolean(this.player.getPlayer())) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.shop.getShopMenu());
            return;
        }
        for (ObjectItem tempVal5 : this.shop.getProductList()) {
            ObjectUseTimesCache tempVal4;
            ObjectUseTimesCache tempVal3 = tempVal1.getUseTimesCache().get(tempVal5);
            if (tempVal3 != null && tempVal3.getBuyRefreshTime() != null && tempVal3.getBuyRefreshTime().isBefore(LocalDateTime.now())) {
                if (ConfigManager.configManager.getBoolean("debug")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset player buy data by GUI open check!");
                }
                tempVal1.getUseTimesCache().get(tempVal5).setBuyUseTimes(0);
                tempVal1.getUseTimesCache().get(tempVal5).setLastBuyTime(null);
            }
            if (tempVal3 != null && tempVal3.getSellRefreshTime() != null && tempVal3.getSellRefreshTime().isBefore(LocalDateTime.now())) {
                if (ConfigManager.configManager.getBoolean("debug")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset player sell data by GUI open check!");
                }
                tempVal1.getUseTimesCache().get(tempVal5).setSellUseTimes(0);
                tempVal1.getUseTimesCache().get(tempVal5).setLastSellTime(null);
            }
            if ((tempVal4 = tempVal2.getUseTimesCache().get(tempVal5)) != null && tempVal4.getBuyRefreshTime() != null && tempVal4.getBuyRefreshTime().isBefore(LocalDateTime.now())) {
                if (ConfigManager.configManager.getBoolean("debug")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset server buy data by GUI open check!");
                }
                tempVal2.getUseTimesCache().get(tempVal5).setBuyUseTimes(0);
                tempVal2.getUseTimesCache().get(tempVal5).setLastBuyTime(null);
            }
            if (tempVal4 == null || tempVal4.getSellRefreshTime() == null || !tempVal4.getSellRefreshTime().isBefore(LocalDateTime.now())) continue;
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7bReset server sell data by GUI open check!");
            }
            tempVal2.getUseTimesCache().get(tempVal5).setSellUseTimes(0);
            tempVal2.getUseTimesCache().get(tempVal5).setLastSellTime(null);
        }
        this.menuButtons = this.shop.getShopMenuObject().getMenu();
        if (ConfigManager.configManager.getBoolean("debug")) {
            for (Integer i : this.menuButtons.keySet()) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fMenu Buttons: " + this.menuButtons.get(i));
            }
        }
        this.menuItems = this.getMenuItems(this.player.getPlayer());
        if (Objects.isNull(this.inv) && this.shop.getShopMenuObject() != null) {
            this.inv = PaperUtil.createNewInv(this.player, this.shop.getShopMenuObject().getInt("size", 54), this.shop.getShopMenuObject().getString("title", this.shop.getShopDisplayName()).replace("{shop-name}", this.shop.getShopDisplayName()));
        }
        Iterator<ObjectItem> iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)((Object)iterator.next());
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        if (this.menuButtons.get(slot) == null) {
            return true;
        }
        ((AbstractButton)this.menuButtons.get(slot)).clickEvent(type, this.player.getPlayer());
        if (ConfigManager.configManager.getBoolean("menu.shop.click-update")) {
            this.constructGUI();
        } else {
            this.menuItems.put(slot, this.getMenuItem(this.player, slot));
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
        return true;
    }

    @Override
    public boolean closeEventHandle(Inventory inventory) {
        if (this.runTask != null) {
            this.runTask.cancel();
        }
        return super.closeEventHandle(inventory);
    }

    @Override
    public ObjectMenu getMenu() {
        return this.shop.getShopMenuObject();
    }
}

