/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.libs.easyplugin;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ColorParser {
    public static final Pattern HEX_PATTERN = Pattern.compile("&#([\\da-fA-F]{6})");
    public static final Pattern GRADIENT_PATTERN = Pattern.compile("&<&?#([\\da-fA-F]{6})>");
    public static final Pattern COLOR_PATTERN = Pattern.compile("([&\u00a7][0-9a-fA-FrRxX])+");
    public static final Pattern FORMAT_PATTERN = Pattern.compile("([&\u00a7][0-9a-fA-Fk-oK-OrRxX])+");

    public static String clear(String text) {
        text = HEX_PATTERN.matcher(text).replaceAll("");
        text = GRADIENT_PATTERN.matcher(text).replaceAll("");
        text = COLOR_PATTERN.matcher(text).replaceAll("");
        return text;
    }

    public static String parse(String text) {
        return ColorParser.parseBaseColor(ColorParser.parseGradientColor(ColorParser.parseHexColor(text)));
    }

    public static String parseBaseColor(String text) {
        return text.replaceAll("&", "\u00a7").replace("\u00a7\u00a7", "&");
    }

    public static String parseHexColor(String text) {
        Matcher matcher = HEX_PATTERN.matcher(text);
        while (matcher.find()) {
            text = matcher.replaceFirst(ColorParser.buildHexColor(matcher.group(1)).toLowerCase());
            matcher.reset(text);
        }
        return text;
    }

    public static String parseGradientColor(String text) {
        ArrayList<String> colors = new ArrayList<String>();
        Matcher matcher = GRADIENT_PATTERN.matcher(text);
        while (matcher.find()) {
            colors.add(matcher.group(1));
        }
        if (colors.isEmpty()) {
            return text;
        }
        String[] parts = GRADIENT_PATTERN.split(text);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String startHex = i - 1 >= 0 && colors.size() > i - 1 ? (String)colors.get(i - 1) : null;
            String endHex = colors.size() > i ? (String)colors.get(i) : null;
            builder.append(ColorParser.gradientText(parts[i], startHex, endHex));
        }
        return builder.toString();
    }

    public static String gradientText(String text, Color startColor, Color endColor) {
        Objects.requireNonNull(text, "Text to be gradient should not be null!");
        if (startColor == null || endColor == null || text.isEmpty()) {
            return (startColor != null ? "&r" : "") + text;
        }
        LinkedHashMap<Integer, String> extraFormats = new LinkedHashMap<Integer, String>();
        Matcher matcher = FORMAT_PATTERN.matcher(text);
        while (matcher.find()) {
            extraFormats.put(matcher.start(), matcher.group());
            text = matcher.replaceFirst("");
            matcher.reset(text);
        }
        if (text.length() == 1) {
            return ColorParser.colorText(text, (String)extraFormats.get(0), ColorParser.buildHexColor(ColorParser.mediumHex(startColor, endColor)));
        }
        String[] characters = text.split("");
        int step = characters.length;
        int rDirection = startColor.getRed() < endColor.getRed() ? 1 : -1;
        int gDirection = startColor.getGreen() < endColor.getGreen() ? 1 : -1;
        int bDirection = startColor.getBlue() < endColor.getBlue() ? 1 : -1;
        int rStep = Math.abs(startColor.getRed() - endColor.getRed()) / (step - 1);
        int gStep = Math.abs(startColor.getGreen() - endColor.getGreen()) / (step - 1);
        int bStep = Math.abs(startColor.getBlue() - endColor.getBlue()) / (step - 1);
        String[] hexes = (String[])IntStream.range(0, step).mapToObj(i -> ColorParser.colorToHex(startColor.getRed() + rStep * i * rDirection, startColor.getGreen() + gStep * i * gDirection, startColor.getBlue() + bStep * i * bDirection)).toArray(String[]::new);
        return IntStream.range(0, characters.length).mapToObj(i -> ColorParser.colorText(characters[i], (String)extraFormats.get(i), ColorParser.buildHexColor(hexes[i]))).collect(Collectors.joining());
    }

    protected static String gradientText(String text, String startHex, String endHex) {
        return ColorParser.gradientText(text, startHex == null ? null : Color.decode("0x" + startHex), endHex == null ? null : Color.decode("0x" + endHex));
    }

    private static String mediumHex(Color start, Color end) {
        return ColorParser.colorToHex(Math.abs(start.getRed() - end.getRed()) / 2, Math.abs(start.getGreen() - end.getGreen()) / 2, Math.abs(start.getBlue() - end.getBlue()) / 2);
    }

    private static String colorText(String message, String format, String color) {
        if (format != null && COLOR_PATTERN.matcher(format).find()) {
            return format + message;
        }
        return (color == null ? "" : color) + (format == null ? "" : ColorParser.parseBaseColor(format)) + message;
    }

    protected static String colorToHex(Color color) {
        return ColorParser.colorToHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    protected static String colorToHex(int r, int g, int b) {
        return String.format("%02X%02X%02X", r, g, b);
    }

    protected static String buildHexColor(String hexCode) {
        return Arrays.stream(hexCode.split("")).map(s -> '\u00a7' + s).collect(Collectors.joining("", "\u00a7x", ""));
    }
}

