/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.database.SQLDatabase;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CacheManager {
    public static CacheManager cacheManager;
    private Map<Player, PlayerCache> playerCacheMap = new ConcurrentHashMap<Player, PlayerCache>();
    public ServerCache serverCache;

    public CacheManager() {
        cacheManager = this;
        if (ConfigManager.configManager.getBoolean("database.enabled")) {
            SQLDatabase.closeSQL();
            SQLDatabase.initSQL();
        }
        this.serverCache = new ServerCache();
        this.initRandomPlaceholderElements();
    }

    private void initRandomPlaceholderElements() {
        for (ObjectRandomPlaceholder randomPlaceholder : ConfigManager.configManager.randomPlaceholders.values()) {
            randomPlaceholder.initElements(false);
        }
    }

    public void addPlayerCache(Player player) {
        this.playerCacheMap.put(player, new PlayerCache(player));
        this.playerCacheMap.get(player).initPlayerCache();
    }

    public PlayerCache getPlayerCache(Player player) {
        PlayerCache tempVal1 = this.playerCacheMap.get(player);
        if (tempVal1 == null) {
            this.addPlayerCache(player);
            tempVal1 = this.playerCacheMap.get(player);
        }
        return tempVal1;
    }

    public void savePlayerCache(Player player) {
        if (this.playerCacheMap.get(player) == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cCan not save player data: " + player.getName() + "! This is usually because this player joined the server before server fully started, ask him rejoin the server.");
            return;
        }
        this.playerCacheMap.get(player).shutPlayerCache(true);
    }

    public void savePlayerCacheOnDisable(Player player, boolean disable) {
        if (this.playerCacheMap.get(player) == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cCan not save player data: " + player.getName() + "! This is usually because this player joined the server before server fully started, ask him rejoin the server.");
            return;
        }
        this.playerCacheMap.get(player).shutPlayerCacheOnDisable(disable);
    }

    public void removePlayerCache(Player player) {
        if (player != null) {
            this.playerCacheMap.remove(player);
        }
    }
}

