/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.commands.AbstractCommand;
import cn.superiormc.ultimateshop.commands.MainCommand;
import cn.superiormc.ultimateshop.commands.MainCommandTab;
import cn.superiormc.ultimateshop.commands.SubAddBuyTimes;
import cn.superiormc.ultimateshop.commands.SubAddSellTimes;
import cn.superiormc.ultimateshop.commands.SubGenerateItemFormat;
import cn.superiormc.ultimateshop.commands.SubGetPlaceholderValue;
import cn.superiormc.ultimateshop.commands.SubGiveSellStick;
import cn.superiormc.ultimateshop.commands.SubHelp;
import cn.superiormc.ultimateshop.commands.SubMenu;
import cn.superiormc.ultimateshop.commands.SubQuickBuy;
import cn.superiormc.ultimateshop.commands.SubQuickSell;
import cn.superiormc.ultimateshop.commands.SubReload;
import cn.superiormc.ultimateshop.commands.SubResetRandomPlaceholder;
import cn.superiormc.ultimateshop.commands.SubSaveItem;
import cn.superiormc.ultimateshop.commands.SubSellAll;
import cn.superiormc.ultimateshop.commands.SubSetBuyTimes;
import cn.superiormc.ultimateshop.commands.SubSetRandomPlaceholder;
import cn.superiormc.ultimateshop.commands.SubSetSellTimes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;

public class CommandManager {
    public static CommandManager commandManager;
    private Map<String, AbstractCommand> registeredCommands = new HashMap<String, AbstractCommand>();

    public CommandManager() {
        commandManager = this;
        this.registerBukkitCommands();
        this.registerObjectCommand();
    }

    private void registerBukkitCommands() {
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"ultimateshop")).setExecutor((CommandExecutor)new MainCommand());
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"ultimateshop")).setTabCompleter((TabCompleter)new MainCommandTab());
    }

    private void registerObjectCommand() {
        this.registerNewSubCommand(new SubSaveItem());
        this.registerNewSubCommand(new SubMenu());
        this.registerNewSubCommand(new SubQuickSell());
        this.registerNewSubCommand(new SubQuickBuy());
        this.registerNewSubCommand(new SubReload());
        this.registerNewSubCommand(new SubGiveSellStick());
        this.registerNewSubCommand(new SubSellAll());
        this.registerNewSubCommand(new SubAddBuyTimes());
        this.registerNewSubCommand(new SubAddSellTimes());
        this.registerNewSubCommand(new SubSetSellTimes());
        this.registerNewSubCommand(new SubSetBuyTimes());
        this.registerNewSubCommand(new SubHelp());
        this.registerNewSubCommand(new SubGenerateItemFormat());
        this.registerNewSubCommand(new SubGetPlaceholderValue());
        this.registerNewSubCommand(new SubResetRandomPlaceholder());
        this.registerNewSubCommand(new SubSetRandomPlaceholder());
    }

    public Map<String, AbstractCommand> getSubCommandsMap() {
        return this.registeredCommands;
    }

    public void registerNewSubCommand(AbstractCommand command) {
        this.registeredCommands.put(command.getId(), command);
    }
}

