/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.ClickType;

public class ConfigManager {
    public static ConfigManager configManager;
    public FileConfiguration config;
    public Map<String, ObjectShop> shopConfigs = new HashMap<String, ObjectShop>();
    public Map<String, ObjectRandomPlaceholder> randomPlaceholders = new HashMap<String, ObjectRandomPlaceholder>();

    public ConfigManager() {
        configManager = this;
        UltimateShop.instance.saveDefaultConfig();
        this.config = UltimateShop.instance.getConfig();
        this.initShopConfigs();
        this.initMenuConfigs();
    }

    private void initShopConfigs() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "shops");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            this.shopConfigs.put(substring, new ObjectShop(substring, YamlConfiguration.loadConfiguration((File)file)));
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fLoaded shop: " + fileName + "!");
        }
    }

    private void initMenuConfigs() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "menus");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String substring;
            String fileName = file.getName();
            if (!fileName.endsWith(".yml") || ObjectMenu.shopMenuNames.contains(substring = fileName.substring(0, fileName.length() - 4)) || ObjectMenu.buyMoreMenuNames.contains(substring)) continue;
            new ObjectMenu(substring);
        }
    }

    private void initRandomPlaceholder() {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection("placeholder.random");
        if (tempVal1 == null) {
            return;
        }
        for (String key : tempVal1.getKeys(false)) {
            this.randomPlaceholders.put(key, new ObjectRandomPlaceholder(key, tempVal1.getConfigurationSection(key)));
        }
    }

    public ObjectShop getShop(String fileName) {
        return this.shopConfigs.get(fileName);
    }

    public Collection<ObjectShop> getShops() {
        return this.shopConfigs.values();
    }

    public List<ObjectShop> getShopList() {
        ArrayList<ObjectShop> resultShops = new ArrayList<ObjectShop>();
        for (String key : this.shopConfigs.keySet()) {
            resultShops.add(this.shopConfigs.get(key));
        }
        return resultShops;
    }

    public ObjectRandomPlaceholder getRandomPlaceholder(String id) {
        return this.randomPlaceholders.get(id);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<String> getStringListOrDefault(String originalPath, String newPath) {
        if (this.config.getStringList(originalPath).isEmpty()) {
            return this.config.getStringList(newPath);
        }
        return this.config.getStringList(originalPath);
    }

    public List<Integer> getIntList(String path) {
        return this.config.getIntegerList(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path, false);
    }

    public boolean getBooleanOrDefault(String originalPath, String newPath) {
        return this.config.getBoolean(originalPath, this.config.getBoolean(newPath, false));
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public int getIntOrDefault(String originalPath, String newPath, int defaultValue) {
        return this.config.getInt(originalPath, this.config.getInt(newPath, defaultValue));
    }

    public long getLong(String path, long defaultValue) {
        return this.config.getLong(path, defaultValue);
    }

    public ConfigurationSection getSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public ConfigurationSection getSectionOrDefault(String originalPath, String newPath) {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection(originalPath);
        if (tempVal1 == null) {
            return this.config.getConfigurationSection(newPath);
        }
        return tempVal1;
    }

    public String getString(String path, String ... args) {
        String s = this.config.getString(path);
        if (s == null) {
            if (args.length == 0) {
                return null;
            }
            s = args[0];
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
        }
        return s.replace("{plugin_folder}", String.valueOf(UltimateShop.instance.getDataFolder()));
    }

    public String getStringOrDefault(String originalPath, String newPath, String defaultValue) {
        return this.config.getString(originalPath, this.config.getString(newPath, defaultValue));
    }

    public String getClickAction(ClickType type) {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection("menu.click-event");
        if (tempVal1 == null) {
            return "none";
        }
        for (String s : tempVal1.getKeys(false)) {
            for (String t : tempVal1.getString(s).split(";;")) {
                if (!t.equals(type.name())) continue;
                return s;
            }
        }
        return "none";
    }

    public boolean containsClickAction(String clickEvent) {
        ConfigurationSection clickEventSection = configManager.getSection("menu.click-event");
        if (clickEventSection == null) {
            return false;
        }
        return clickEventSection.contains(clickEvent);
    }

    public Collection<ObjectRandomPlaceholder> getRandomPlaceholders() {
        return this.randomPlaceholders.values();
    }

    public Collection<String> getDiscountPlaceholderIDs() {
        ConfigurationSection section = this.config.getConfigurationSection("placeholder.random");
        if (section == null) {
            return new ArrayList<String>();
        }
        return section.getKeys(false);
    }
}

