/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemManager {
    private static Map<String, ItemStack> savedItemMap = new HashMap<String, ItemStack>();
    public static ItemManager itemManager;

    public ItemManager() {
        itemManager = this;
        this.initSavedItems();
    }

    public void initSavedItems() {
        File[] tempList;
        savedItemMap.clear();
        File dir = new File(UltimateShop.instance.getDataFolder() + "/items");
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (File file : tempList = dir.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            ItemStack itemStack = YamlConfiguration.loadConfiguration((File)file).getItemStack("item");
            String key = file.getName();
            key = key.substring(0, key.length() - 4);
            savedItemMap.put(key, itemStack);
        }
    }

    public void saveMainHandItem(Player player, String key) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        File dir = new File(UltimateShop.instance.getDataFolder() + "/items");
        if (!dir.exists()) {
            dir.mkdir();
        }
        YamlConfiguration itemConfig = new YamlConfiguration();
        itemConfig.set("item", (Object)itemStack);
        String yaml = itemConfig.saveToString();
        savedItemMap.put(key, itemStack);
        if (UltimateShop.isFolia) {
            Path path = new File(dir.getPath(), key + ".yml").toPath();
            try {
                Files.write(path, yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)UltimateShop.instance, () -> {
            Path path = new File(dir.getPath(), key + ".yml").toPath();
            try {
                Files.write(path, yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public ItemStack getItemByKey(String key) {
        if (savedItemMap.containsKey(key)) {
            return savedItemMap.get(key).clone();
        }
        return null;
    }
}

