/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TaskManager {
    public static TaskManager taskManager;
    private BukkitTask saveTask;
    private ScheduledTask saveFoliaTask;

    public TaskManager() {
        taskManager = this;
        if (ConfigManager.configManager.getBoolean("auto-save.enabled")) {
            this.initSaveTasks();
        }
    }

    public void initSaveTasks() {
        if (UltimateShop.isFolia) {
            this.saveFoliaTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)UltimateShop.instance, task -> {
                if (!ConfigManager.configManager.getBoolean("auto-save.hide-message")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fAuto saving data...");
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fIf this lead to server TPS drop, you should consider disable auto save feature at config.yml!");
                }
                ServerCache.serverCache.shutServerCache(false);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (CacheManager.cacheManager.getPlayerCache(player) == null) continue;
                    CacheManager.cacheManager.getPlayerCache(player).shutPlayerCache(false);
                }
            }, 180L, ConfigManager.configManager.config.getLong("auto-save.period-tick", 600L));
        } else {
            this.saveTask = Bukkit.getScheduler().runTaskTimer((Plugin)UltimateShop.instance, () -> {
                if (!ConfigManager.configManager.getBoolean("auto-save.hide-message")) {
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fAuto saving data...");
                    Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fIf this lead to server TPS drop, you should consider disable auto save feature at config.yml!");
                }
                ServerCache.serverCache.shutServerCache(false);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (CacheManager.cacheManager.getPlayerCache(player) == null) continue;
                    CacheManager.cacheManager.getPlayerCache(player).shutPlayerCache(false);
                }
            }, 180L, ConfigManager.configManager.config.getLong("auto-save.period-tick", 600L));
        }
    }

    public void cancelTask() {
        if (UltimateShop.isFolia && this.saveFoliaTask != null) {
            this.saveFoliaTask.cancel();
        } else if (this.saveTask != null) {
            this.saveTask.cancel();
        }
    }
}

