/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods.Items;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.hooks.CheckValidHook;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class DebuildItem {
    /*
     * WARNING - void declaration
     */
    public static ConfigurationSection debuildItem(ItemStack itemStack, ConfigurationSection section) {
        MusicInstrumentMeta musicInstrumentMeta;
        OminousBottleMeta ominousBottleMeta;
        BundleMeta bundleMeta;
        FireworkEffectMeta fireworkEffectMeta;
        TropicalFishBucketMeta tropicalFishBucketMeta;
        AxolotlBucketMeta axolotlBucketMeta;
        LeatherArmorMeta leatherArmorMeta;
        ArmorMeta armorMeta;
        Set flags;
        if (CheckValidHook.checkValid(itemStack) != null) {
            section.set("hook-plugin", (Object)CheckValidHook.checkValid(itemStack)[0]);
            section.set("hook-item", (Object)CheckValidHook.checkValid(itemStack)[1]);
        } else {
            section.set("material", (Object)itemStack.getType().name());
        }
        section.set("amount", (Object)itemStack.getAmount());
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return section;
        }
        if (meta.hasDisplayName()) {
            if (UltimateShop.isPaper && ConfigManager.configManager.getBoolean("use-component.item")) {
                section.set("name", (Object)meta.displayName());
            } else {
                section.set("name", (Object)meta.getDisplayName());
            }
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta.hasItemName()) {
            section.set("item-name", (Object)meta.getItemName());
        }
        if (meta.hasLore()) {
            if (UltimateShop.isPaper && ConfigManager.configManager.getBoolean("use-component.item")) {
                section.set("lore", (Object)meta.lore());
            } else {
                section.set("lore", (Object)meta.getLore());
            }
        }
        if (meta.hasCustomModelData()) {
            section.set("custom-model-data", (Object)meta.getCustomModelData());
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta.hasMaxStackSize()) {
            section.set("max-stack", (Object)meta.getMaxStackSize());
        }
        if (CommonUtil.getMinorVersion(20, 5)) {
            FoodComponent foodComponent = meta.getFood();
            if (foodComponent.getEatSeconds() != 1.6f) {
                section.set("food.eat-seconds", (Object)Float.valueOf(foodComponent.getEatSeconds()));
            }
            if (foodComponent.canAlwaysEat()) {
                section.set("food.can-alawys-eat", (Object)true);
            }
            if (foodComponent.getNutrition() > 0) {
                section.set("food.nutrition", (Object)foodComponent.getNutrition());
            }
            if (foodComponent.getSaturation() > 0.0f) {
                section.set("food.saturation", (Object)Float.valueOf(foodComponent.getSaturation()));
            }
            if (CommonUtil.getMajorVersion(21) && foodComponent.getUsingConvertsTo() != null) {
                DebuildItem.debuildItem(foodComponent.getUsingConvertsTo(), section.createSection("food.convert"));
            }
            ArrayList<String> effects = new ArrayList<String>();
            for (FoodComponent.FoodEffect foodEffect : foodComponent.getEffects()) {
                if (CommonUtil.getMajorVersion(18)) {
                    effects.add(foodEffect.getEffect().getType().getKey() + ", " + foodEffect.getEffect().getDuration() + ", " + foodEffect.getEffect().getAmplifier() + ", " + foodEffect.getEffect().isAmbient() + ", " + foodEffect.getEffect().hasParticles() + ", " + foodEffect.getEffect().hasIcon() + ", " + foodEffect.getProbability());
                    continue;
                }
                effects.add(foodEffect.getEffect().getType().getName() + ", " + foodEffect.getEffect().getDuration() + ", " + foodEffect.getEffect().getAmplifier() + ", " + foodEffect.getEffect().isAmbient() + ", " + foodEffect.getEffect().hasParticles() + ", " + foodEffect.getEffect().hasIcon() + ", " + foodEffect.getProbability());
            }
            if (!effects.isEmpty()) {
                section.set("effects", effects);
            }
        }
        if (CommonUtil.getMajorVersion(21)) {
            ToolComponent toolComponent = meta.getTool();
            if (toolComponent.getDamagePerBlock() != 0) {
                section.set("tool.damage-per-block", (Object)toolComponent.getDamagePerBlock());
            }
            if (toolComponent.getDefaultMiningSpeed() != 1.0f) {
                section.set("tool.mining-speed", (Object)Float.valueOf(toolComponent.getDefaultMiningSpeed()));
            }
            ArrayList<String> toolRules = new ArrayList<String>();
            for (ToolComponent.ToolRule toolRule : toolComponent.getRules()) {
                if (toolRule.getBlocks().isEmpty()) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (Material material : toolRule.getBlocks()) {
                    if (stringBuilder.toString().isEmpty()) {
                        stringBuilder.append(material.name());
                        continue;
                    }
                    stringBuilder.append(", ").append(material.name());
                }
                stringBuilder.append(", ").append(toolRule.getSpeed()).append(", ").append(toolRule.isCorrectForDrops());
                toolRules.add(stringBuilder.toString());
            }
            if (!toolRules.isEmpty()) {
                section.set("tool.rules", toolRules);
            }
        }
        if (CommonUtil.getMajorVersion(21)) {
            JukeboxPlayableComponent jukeboxPlayableComponent = meta.getJukeboxPlayable();
            if (!jukeboxPlayableComponent.isShowInTooltip()) {
                section.set("show-song", (Object)jukeboxPlayableComponent.isShowInTooltip());
            }
            if (!jukeboxPlayableComponent.getSongKey().toString().equals("minecraft:13")) {
                section.set("song", (Object)jukeboxPlayableComponent.getSongKey().toString());
            }
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta.isFireResistant()) {
            section.set("fire-resistant", (Object)"true");
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta.isHideTooltip()) {
            section.set("hide-tool-tip", (Object)"true");
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta.hasEnchantmentGlintOverride()) {
            section.set("hide-tool-tip", (Object)"true");
        }
        if (meta.isUnbreakable()) {
            section.set("unbreakable", (Object)"true");
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta.hasRarity()) {
            section.set("rarity", (Object)meta.getRarity().name());
        }
        if (!(flags = meta.getItemFlags()).isEmpty()) {
            ArrayList flagNames = new ArrayList();
            for (ItemFlag flag : flags) {
                flagNames.add(flag.name());
            }
            section.set("flags", (Object)flagNames);
        }
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            String entry2 = "enchants." + ((Enchantment)entry.getKey()).getKey().getKey();
            section.set(entry2, entry.getValue());
        }
        Multimap attributes = meta.getAttributeModifiers();
        if (attributes != null) {
            for (Object attribute : attributes.entries()) {
                String string = "attributes." + ((Attribute)attribute.getKey()).name() + '.';
                AttributeModifier modifier = (AttributeModifier)attribute.getValue();
                if (!CommonUtil.getMajorVersion(21)) {
                    section.set(string + "id", (Object)modifier.getUniqueId().toString());
                }
                section.set(string + "name", (Object)modifier.getName());
                section.set(string + "amount", (Object)modifier.getAmount());
                section.set(string + "operation", (Object)modifier.getOperation().name());
                if (CommonUtil.getMinorVersion(20, 5)) {
                    section.set(string + "slot", (Object)modifier.getSlotGroup().toString());
                    continue;
                }
                if (modifier.getSlot() == null) continue;
                section.set(string + "slot", (Object)modifier.getSlot().name());
            }
        }
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            if (damageable.hasDamage()) {
                section.set("damage", (Object)damageable.getDamage());
            }
            if (CommonUtil.getMinorVersion(20, 5) && damageable.hasMaxDamage()) {
                section.set("max-damage", (Object)damageable.getMaxDamage());
            }
        }
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
            for (Map.Entry entry : enchantmentStorageMeta.getStoredEnchants().entrySet()) {
                String entry3 = "stored-enchants." + ((Enchantment)entry.getKey()).getKey().getKey();
                section.set(entry3, entry.getValue());
            }
        }
        if (meta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)meta;
            ConfigurationSection patterns = section.createSection("patterns");
            for (Pattern pattern : bannerMeta.getPatterns()) {
                patterns.set(pattern.getPattern().name(), (Object)pattern.getColor().name());
            }
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            ArrayList<String> effects = new ArrayList<String>();
            for (Object effect : potionMeta.getCustomEffects()) {
                if (CommonUtil.getMajorVersion(18)) {
                    effects.add(effect.getType().getKey() + ", " + effect.getDuration() + ", " + effect.getAmplifier() + ", " + effect.getAmplifier() + ", " + effect.isAmbient() + ", " + effect.hasParticles() + ", " + effect.hasIcon());
                    continue;
                }
                effects.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier() + ", " + effect.getAmplifier() + ", " + effect.isAmbient() + ", " + effect.hasParticles() + ", " + effect.hasIcon());
            }
            if (!effects.isEmpty()) {
                section.set("effects", effects);
            }
            if (CommonUtil.getMinorVersion(20, 5)) {
                PotionType potionType = potionMeta.getBasePotionType();
                if (potionType != null) {
                    section.set("base-effect", (Object)potionType.getKey().toString());
                }
            } else {
                PotionData potionData = potionMeta.getBasePotionData();
                if (potionData != null) {
                    section.set("base-effect", (Object)(potionData.getType().name() + ", " + potionData.isExtended() + ", " + potionData.isUpgraded()));
                }
            }
            if (potionMeta.hasColor()) {
                section.set("color", (Object)potionMeta.getColor().asRGB());
            }
        }
        if (CommonUtil.getMajorVersion(20) && meta instanceof ArmorMeta && (armorMeta = (ArmorMeta)meta).hasTrim()) {
            ArmorTrim trim = armorMeta.getTrim();
            ConfigurationSection configurationSection = section.createSection("trim");
            configurationSection.set("material", (Object)trim.getMaterial().getKey().toString());
            configurationSection.set("pattern", (Object)trim.getPattern().getKey().toString());
        }
        if (meta instanceof LeatherArmorMeta && (leatherArmorMeta = (LeatherArmorMeta)meta).getColor().asRGB() != 10511680) {
            Color color = leatherArmorMeta.getColor();
            section.set("color", (Object)color.asRGB());
        }
        if (CommonUtil.getMajorVersion(17) && meta instanceof AxolotlBucketMeta && (axolotlBucketMeta = (AxolotlBucketMeta)meta).hasVariant()) {
            section.set("color", (Object)axolotlBucketMeta.getVariant().toString());
        }
        if (meta instanceof TropicalFishBucketMeta && (tropicalFishBucketMeta = (TropicalFishBucketMeta)meta).hasVariant()) {
            section.set("pattern", (Object)tropicalFishBucketMeta.getPattern().name());
            section.set("color", (Object)tropicalFishBucketMeta.getBodyColor().name());
            section.set("pattern-color", (Object)tropicalFishBucketMeta.getPatternColor().name());
        }
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            if (skullMeta.hasOwner()) {
                section.set("skull", (Object)skullMeta.getOwningPlayer().getName());
            } else {
                try {
                    Field field = skullMeta.getClass().getDeclaredField("profile");
                    field.setAccessible(true);
                    GameProfile gameProfile = (GameProfile)field.get(skullMeta);
                    if (gameProfile != null) {
                        Property property = (Property)gameProfile.getProperties().get((Object)"textures").iterator().next();
                        section.set("skull", (Object)property.getValue());
                    }
                }
                catch (Exception exception) {
                    ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[ManyouItems] \u00a7cError: Can not parse skull texture in a item!");
                }
            }
        }
        if (meta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            section.set("power", (Object)fireworkMeta.getPower());
            int i = 1;
            for (FireworkEffect fw : fireworkMeta.getEffects()) {
                section.set("firework." + i + ".type", (Object)fw.getType().name());
                section.set("firework." + i + ".flicker", (Object)fw.hasFlicker());
                section.set("firework." + i + ".trail", (Object)fw.hasTrail());
                ArrayList<Integer> baseColors = new ArrayList<Integer>();
                ArrayList<Integer> fadeColors = new ArrayList<Integer>();
                ConfigurationSection colors = section.createSection("firework." + i + ".colors");
                for (Color color : fw.getColors()) {
                    baseColors.add(color.asRGB());
                }
                colors.set("base", baseColors);
                for (Color color : fw.getFadeColors()) {
                    fadeColors.add(color.asRGB());
                }
                colors.set("fade", fadeColors);
                ++i;
            }
        }
        if (meta instanceof FireworkEffectMeta && (fireworkEffectMeta = (FireworkEffectMeta)meta).hasEffect()) {
            FireworkEffect fireworkEffect = fireworkEffectMeta.getEffect();
            section.set("firework.type", (Object)fireworkEffect.getType().name());
            section.set("firework.flicker", (Object)fireworkEffect);
            section.set("firework.trail", (Object)fireworkEffect.hasTrail());
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> fadeColors = new ArrayList<Integer>();
            ConfigurationSection colors = section.createSection("firework.colors");
            for (Color color : fireworkEffect.getColors()) {
                arrayList.add(color.asRGB());
            }
            colors.set("base", arrayList);
            for (Color color : fireworkEffect.getFadeColors()) {
                fadeColors.add(color.asRGB());
            }
            colors.set("fade", fadeColors);
        }
        if (meta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta suspiciousStewMeta = (SuspiciousStewMeta)meta;
            ArrayList<String> effects = new ArrayList<String>();
            for (Object effect : suspiciousStewMeta.getCustomEffects()) {
                if (CommonUtil.getMajorVersion(18)) {
                    effects.add(effect.getType().getKey() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
                    continue;
                }
                effects.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
            }
            section.set("effects", effects);
        }
        if (CommonUtil.getMajorVersion(17) && meta instanceof BundleMeta && (bundleMeta = (BundleMeta)meta).hasItems()) {
            ConfigurationSection bundleContentKey = section.createSection("contents");
            boolean bl = false;
            for (ItemStack singleItem : bundleMeta.getItems()) {
                void var7_77;
                if (singleItem != null && !singleItem.getType().isAir()) {
                    DebuildItem.debuildItem(singleItem, bundleContentKey.createSection(Integer.toString((int)var7_77)));
                }
                ++var7_77;
            }
        }
        if (meta instanceof BlockStateMeta) {
            BrushableBlock brushableBlock;
            BlockState blockState = ((BlockStateMeta)meta).getBlockState();
            if (blockState instanceof CreatureSpawner) {
                CreatureSpawner cs = (CreatureSpawner)blockState;
                if (cs.getSpawnedType() != null) {
                    section.set("spawner", (Object)cs.getSpawnedType().name());
                }
                section.set("min-delay", (Object)cs.getMinSpawnDelay());
                section.set("max-delay", (Object)cs.getMaxSpawnDelay());
                section.set("max-entities", (Object)cs.getMaxNearbyEntities());
                section.set("player-range", (Object)cs.getRequiredPlayerRange());
                section.set("spawn-range", (Object)cs.getSpawnRange());
            } else if (blockState instanceof ShulkerBox) {
                ShulkerBox box = (ShulkerBox)blockState;
                if (!box.getInventory().isEmpty()) {
                    ConfigurationSection configurationSection = section.createSection("contents");
                    int i = 0;
                    for (ItemStack singleItem : box.getInventory().getContents()) {
                        if (singleItem != null && !singleItem.getType().isAir()) {
                            DebuildItem.debuildItem(singleItem, configurationSection.createSection(Integer.toString(i)));
                        }
                        ++i;
                    }
                }
            } else if (CommonUtil.getMajorVersion(20) && blockState instanceof BrushableBlock && (brushableBlock = (BrushableBlock)blockState).getItem() != null && !brushableBlock.getItem().getType().isAir()) {
                DebuildItem.debuildItem(brushableBlock.getItem(), section.createSection("content"));
            }
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta instanceof OminousBottleMeta && (ominousBottleMeta = (OminousBottleMeta)meta).hasAmplifier()) {
            section.set("power", (Object)ominousBottleMeta.getAmplifier());
        }
        if (CommonUtil.getMinorVersion(19, 3) && meta instanceof MusicInstrumentMeta && (musicInstrumentMeta = (MusicInstrumentMeta)meta).getInstrument() != null) {
            section.set("music", (Object)musicInstrumentMeta.getInstrument().getKey().toString());
        }
        return section;
    }
}

