/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods.Product;

import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.time.LocalDateTime;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;

public class BuyProductMethod {
    public static ProductTradeStatus startBuy(String shop, String product, Player player, boolean quick) {
        return BuyProductMethod.startBuy(shop, product, player, quick, false, 1);
    }

    public static ProductTradeStatus startBuy(String shop, String product, Player player, boolean quick, boolean test, int multi) {
        return BuyProductMethod.startBuy((Inventory)player.getInventory(), shop, product, player, quick, test, multi);
    }

    public static ProductTradeStatus startBuy(Inventory inventory, String shop, String product, Player player, boolean quick, boolean test, int multi) {
        ObjectShop tempVal1 = ConfigManager.configManager.getShop(shop);
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.shop-not-found", "shop", shop);
            return ProductTradeStatus.ERROR;
        }
        boolean shouldSendMessage = inventory instanceof PlayerInventory && !test && (quick || !tempVal1.getShopConfig().getBoolean("settings.hide-message", false));
        ObjectItem tempVal2 = tempVal1.getProduct(product);
        if (tempVal2 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.product-not-found", "product", product);
            return ProductTradeStatus.ERROR;
        }
        if (!tempVal2.getBuyCondition(player)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "buy-condition-not-meet", "product", product);
            }
            return ProductTradeStatus.PERMISSION;
        }
        if (tempVal2.getBuyPrice().empty) {
            return ProductTradeStatus.ERROR;
        }
        PlayerCache tempVal3 = CacheManager.cacheManager.getPlayerCache(player);
        ServerCache tempVal11 = ServerCache.serverCache;
        if (tempVal3 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.player-not-found", "player", player.getName());
            return ProductTradeStatus.ERROR;
        }
        int playerUseTimes = 0;
        int serverUseTimes = 0;
        ObjectUseTimesCache tempVal9 = tempVal3.getUseTimesCache().get(tempVal2);
        ObjectUseTimesCache tempVal8 = tempVal11.getUseTimesCache().get(tempVal2);
        if (tempVal9 != null) {
            if (tempVal9.getBuyRefreshTime() != null && tempVal9.getBuyRefreshTime().isBefore(LocalDateTime.now())) {
                tempVal3.getUseTimesCache().get(tempVal2).setBuyUseTimes(0);
            }
            if (tempVal9.getCooldownBuyRefreshTime() != null && tempVal9.getCooldownBuyRefreshTime().isAfter(LocalDateTime.now())) {
                if (shouldSendMessage) {
                    LanguageManager.languageManager.sendStringText(player, "buy-in-cooldown", "item", tempVal2.getDisplayName(player), "refresh", tempVal9.getBuyCooldownTimeDisplayName());
                }
                return ProductTradeStatus.IN_COOLDOWN;
            }
            playerUseTimes = tempVal9.getBuyUseTimes();
        } else {
            tempVal3.setUseTimesCache(shop, product, 0, 0, null, null, null, null);
            tempVal9 = tempVal3.getUseTimesCache().get(tempVal2);
        }
        if (tempVal2.getPlayerBuyLimit(player) != -1 && playerUseTimes + multi > tempVal2.getPlayerBuyLimit(player)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "limit-reached-buy-player", "item", tempVal2.getDisplayName(player), "times", String.valueOf(playerUseTimes), "limit", String.valueOf(tempVal2.getPlayerBuyLimit(player)), "refresh", tempVal9.getBuyRefreshTimeDisplayName());
            }
            return ProductTradeStatus.PLAYER_MAX;
        }
        ObjectPrices tempVal5 = tempVal2.getBuyPrice();
        if (tempVal8 != null) {
            if (quick && tempVal8.getBuyRefreshTime() != null && tempVal8.getBuyRefreshTime().isBefore(LocalDateTime.now())) {
                ServerCache.serverCache.getUseTimesCache().get(tempVal2).setBuyUseTimes(0);
                ServerCache.serverCache.getUseTimesCache().get(tempVal2).setLastBuyTime(null);
            }
            serverUseTimes = ServerCache.serverCache.getUseTimesCache().get(tempVal2).getBuyUseTimes();
        } else {
            tempVal11.setUseTimesCache(shop, product, 0, 0, null, null, null, null);
            tempVal8 = tempVal11.getUseTimesCache().get(tempVal2);
        }
        if (tempVal2.getServerBuyLimit(player) != -1 && serverUseTimes + multi > tempVal2.getServerBuyLimit(player)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "limit-reached-buy-server", "item", tempVal2.getDisplayName(player), "times", String.valueOf(serverUseTimes), "limit", String.valueOf(tempVal2.getServerBuyLimit(player)), "refresh", tempVal8.getBuyRefreshTimeDisplayName());
            }
            return ProductTradeStatus.SERVER_MAX;
        }
        TakeResult takeResult = tempVal5.takeSingleThing(inventory, player, playerUseTimes, multi, false);
        if (!takeResult.getResultBoolean()) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "buy-price-not-enough", "item", tempVal2.getDisplayName(player), "price", ObjectPrices.getDisplayNameInLine(player, multi, takeResult.getResultMap(), tempVal5.getMode(), !ConfigManager.configManager.getBoolean("placeholder.status.can-used-everywhere")));
            }
            return ProductTradeStatus.NOT_ENOUGH;
        }
        if (test) {
            return new ProductTradeStatus(ProductTradeStatus.Status.DONE, takeResult);
        }
        GiveResult giveResult = tempVal2.getReward().giveSingleThing(player, playerUseTimes, multi);
        if (!tempVal2.getReward().giveThing(player, giveResult.getResultMap())) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "inventory-full");
            }
            return ProductTradeStatus.INVENTORY_FULL;
        }
        tempVal5.takeThing(inventory, player, takeResult.getResultMap());
        tempVal2.getBuyAction().doAction(player, playerUseTimes, multi, false);
        if (tempVal9 != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7aSet player limit value to " + tempVal9.getBuyUseTimes() + multi + "!");
            }
            tempVal9.setBuyUseTimes(tempVal9.getBuyUseTimes() + multi);
            tempVal9.setLastBuyTime(LocalDateTime.now());
            tempVal9.setCooldownBuyTime();
            tempVal3.getUseTimesCache().put(tempVal2, tempVal9);
        }
        if (tempVal8 != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7aSet server limit value to " + tempVal8.getBuyUseTimes() + multi + "!");
            }
            tempVal8.setBuyUseTimes(tempVal8.getBuyUseTimes() + multi);
            tempVal8.setLastBuyTime(LocalDateTime.now());
            tempVal11.getUseTimesCache().put(tempVal2, tempVal8);
        }
        if (tempVal1.getShopConfig().getBoolean("settings.send-messages-after-buy", true)) {
            LanguageManager.languageManager.sendStringText(player, "success-buy", "item", tempVal2.getDisplayName(player), "price", ObjectPrices.getDisplayNameInLine(player, multi, takeResult.getResultMap(), tempVal5.getMode(), !ConfigManager.configManager.getBoolean("placeholder.status.can-used-everywhere")), "amount", String.valueOf(multi));
        }
        if (ConfigManager.configManager.getBoolean("log-transaction.enabled")) {
            // empty if block
        }
        return new ProductTradeStatus(ProductTradeStatus.Status.DONE, takeResult, giveResult, multi);
    }

    private static /* synthetic */ void lambda$startBuy$0(String filePath, String log) {
        CommonUtil.logFile(filePath, log);
    }
}

