/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.Items.BuildItem;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellStickItem {
    public static final NamespacedKey SELL_STICK_TIMES = new NamespacedKey((Plugin)UltimateShop.instance, "sell_stick_usage");
    public static final NamespacedKey SELL_STICK_ID = new NamespacedKey((Plugin)UltimateShop.instance, "sell_stick_id");
    public static final NamespacedKey SELL_STICK_INFINITE = new NamespacedKey((Plugin)UltimateShop.instance, "sell_stick_infinite");

    public static ItemStack getSellStick(Player player, String itemID, int amount) {
        int times;
        ConfigurationSection section = ConfigManager.configManager.config.getConfigurationSection("sell-stick-items." + itemID);
        if (section == null) {
            LanguageManager.languageManager.sendStringText("error-item-not-found", "item", itemID);
            return null;
        }
        return SellStickItem.getSellStick(player, itemID, amount, times, (times = section.getInt("usage-times", -1)) <= 0);
    }

    public static ItemStack getSellStick(Player player, String itemID, int amount, int times, boolean infinite) {
        ConfigurationSection section = ConfigManager.configManager.config.getConfigurationSection("sell-stick-items." + itemID);
        if (section == null) {
            LanguageManager.languageManager.sendStringText("error-item-not-found", "item", itemID);
            return null;
        }
        if (times <= 0 && !infinite) {
            return null;
        }
        ItemStack resultItem = BuildItem.buildItemStack(player, section, 1, new String[0]);
        resultItem.setAmount(amount);
        if (!resultItem.hasItemMeta()) {
            ItemMeta tempMeta = Bukkit.getItemFactory().getItemMeta(resultItem.getType());
            resultItem.setItemMeta(tempMeta);
        }
        ItemMeta meta = resultItem.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        if (meta.hasLore()) {
            for (String str : meta.getLore()) {
                str = !infinite ? str.replace("{times}", String.valueOf(times)) : str.replace("{times}", TextUtil.parse(player, ConfigManager.configManager.getString("placeholder.sell-stick.infinite", new String[0])));
                newLore.add(str);
            }
            meta.setLore(newLore);
        }
        meta.getPersistentDataContainer().remove(SELL_STICK_ID);
        meta.getPersistentDataContainer().remove(SELL_STICK_TIMES);
        meta.getPersistentDataContainer().set(SELL_STICK_ID, PersistentDataType.STRING, (Object)itemID);
        if (!infinite) {
            meta.getPersistentDataContainer().set(SELL_STICK_TIMES, PersistentDataType.INTEGER, (Object)times);
        } else {
            meta.getPersistentDataContainer().set(SELL_STICK_INFINITE, PersistentDataType.BOOLEAN, (Object)true);
        }
        resultItem.setItemMeta(meta);
        return resultItem;
    }

    public static String getSellStickID(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.getPersistentDataContainer().has(SELL_STICK_ID, PersistentDataType.STRING)) {
            return null;
        }
        return (String)meta.getPersistentDataContainer().get(SELL_STICK_ID, PersistentDataType.STRING);
    }

    public static int getSellStickValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (!item.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (SellStickItem.sellStickIsInfinite(item)) {
            return 1;
        }
        if (!meta.getPersistentDataContainer().has(SELL_STICK_TIMES, PersistentDataType.INTEGER)) {
            return 0;
        }
        return (Integer)meta.getPersistentDataContainer().get(SELL_STICK_TIMES, PersistentDataType.INTEGER);
    }

    public static void removeSellStickValue(Player player, ItemStack item) {
        ItemStack tempItem;
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        if (SellStickItem.sellStickIsInfinite(item)) {
            return;
        }
        int nowValue = SellStickItem.getSellStickValue(item);
        String id = SellStickItem.getSellStickID(item);
        item.setAmount(item.getAmount() - 1);
        if (id == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not found sell stick item ID");
        } else if (nowValue - 1 > 0 && (tempItem = SellStickItem.getSellStick(player, id, 1, nowValue - 1, false)) != null) {
            CommonUtil.giveOrDrop(player, tempItem);
        }
    }

    public static boolean sellStickIsInfinite(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(SELL_STICK_INFINITE, PersistentDataType.BOOLEAN) && (Boolean)meta.getPersistentDataContainer().get(SELL_STICK_INFINITE, PersistentDataType.BOOLEAN) != false;
    }
}

