/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class ObjectShop {
    private YamlConfiguration config;
    private Map<String, ObjectItem> items = new HashMap<String, ObjectItem>();
    public Map<String, AbstractButton> buttonItems = new HashMap<String, AbstractButton>();
    private String shopName;
    private ObjectMenu menu;

    public ObjectShop(String fileName, YamlConfiguration config) {
        this.shopName = fileName;
        this.config = config;
        this.initProducts();
        this.initButtonItems();
        if (config.getString("settings.menu") != null) {
            this.initMenus();
        }
    }

    private void initProducts() {
        if (this.config.getConfigurationSection("items") == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get items section in your shop config!!");
            return;
        }
        for (String s : this.config.getConfigurationSection("items").getKeys(false)) {
            this.items.put(s, new ObjectItem(this, this.config.getConfigurationSection("items." + s)));
        }
    }

    private void initMenus() {
        if (this.config.getString("settings.menu") != null) {
            this.menu = new ObjectMenu(this.config.getString("settings.menu"), this);
        }
    }

    public void initButtonItems() {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection("buttons");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            this.buttonItems.put(button, new ObjectButton(tempVal1.getConfigurationSection(button), this));
        }
    }

    public YamlConfiguration getShopConfig() {
        return this.config;
    }

    public AbstractButton getButton(String buttonID) {
        if (buttonID == null) {
            return null;
        }
        return this.buttonItems.get(buttonID);
    }

    public ObjectItem getProduct(String productID) {
        if (productID == null) {
            return null;
        }
        return this.items.get(productID);
    }

    public List<ObjectItem> getProductList() {
        ArrayList<ObjectItem> resultItems = new ArrayList<ObjectItem>();
        for (String key : this.items.keySet()) {
            resultItems.add(this.items.get(key));
        }
        return resultItems;
    }

    public String getShopName() {
        return this.shopName;
    }

    public String getShopMenu() {
        if (this.menu == null) {
            return "";
        }
        return this.menu.getName();
    }

    @Nullable
    public ObjectMenu getShopMenuObject() {
        return this.menu;
    }

    public String getShopDisplayName() {
        return this.config.getString("settings.shop-name", this.menu == null ? "" : this.menu.getName());
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public String toString() {
        return this.getShopName();
    }
}

