/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ButtonType;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ObjectButton
extends AbstractButton {
    private ObjectShop shop;
    private ObjectAction action;
    private ObjectAction failAction;
    private ObjectCondition condition;
    private ObjectDisplayItem displayItem;

    public ObjectButton(ConfigurationSection config) {
        super(config);
        this.type = ButtonType.COMMON;
        if (config == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not found config for button, there is something wrong in your menu configs!");
            return;
        }
        this.initButton();
    }

    public ObjectButton(ConfigurationSection config, ObjectShop shop) {
        super(config);
        this.type = ButtonType.COMMON;
        this.shop = shop;
        if (config == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not found config for button, there is something wrong in your menu configs!");
            return;
        }
        this.initButton();
    }

    private void initButton() {
        if (this.shop == null) {
            this.action = new ObjectAction(this.config.getStringList("actions"));
            this.failAction = new ObjectAction(this.config.getStringList("fail-actions"));
        } else {
            this.action = new ObjectAction((List<String>)this.config.getStringList("actions"), this.shop);
            this.failAction = new ObjectAction((List<String>)this.config.getStringList("fail-actions"), this.shop);
        }
        this.condition = new ObjectCondition(this.config.getStringList("conditions"));
        this.displayItem = new ObjectDisplayItem(this.config.getConfigurationSection("display-item"), this.config.getConfigurationSection("display-item-conditions"));
    }

    @Override
    public void clickEvent(ClickType type, Player player) {
        if (this.condition != null && !this.condition.getBoolean(player)) {
            this.failAction.doAction(player, 1, 1, false, type);
            return;
        }
        if (this.action != null) {
            this.action.doAction(player, 1, 1, false, type);
        }
    }

    @Override
    public ItemStack getDisplayItem(Player player, int unUsed) {
        if (this.displayItem == null) {
            return new ItemStack(Material.AIR);
        }
        return this.displayItem.getDisplayItem(player);
    }
}

