/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.form.FormInfoGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.GUI.OpenGUI;
import cn.superiormc.ultimateshop.methods.Product.BuyProductMethod;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ButtonType;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectItemConfig;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.items.ObjectLimit;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.objects.items.prices.PriceMode;
import cn.superiormc.ultimateshop.objects.items.products.ObjectProducts;
import cn.superiormc.ultimateshop.objects.menus.ObjectMoreMenu;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.ItemUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ObjectItem
extends AbstractButton {
    private final ObjectShop shop;
    private ObjectDisplayItem displayItem;
    private ObjectPrices buyPrice;
    private ObjectPrices sellPrice;
    private ObjectProducts reward;
    private ObjectAction buyAction;
    private ObjectAction sellAction;
    private ObjectAction failAction;
    private ObjectCondition buyCondition;
    private ObjectCondition sellCondition;
    private ObjectLimit buyLimit;
    private ObjectLimit sellLimit;
    private final ObjectItemConfig itemConfig;

    public ObjectItem(ObjectShop shop, ConfigurationSection originalConfig) {
        super(originalConfig);
        this.shop = shop;
        this.type = ButtonType.SHOP;
        this.itemConfig = new ObjectItemConfig(this, originalConfig);
        this.initReward();
        this.initBuyPrice();
        this.initSellPrice();
        this.initBuyAction();
        this.initSellAction();
        this.initFailAction();
        this.initBuyCondition();
        this.initSellCondition();
        this.initBuyLimit();
        this.initSellLimit();
        if (this.getBuyMore()) {
            this.initBuyMoreMenu();
        }
        this.initDisplayItem();
    }

    private void initDisplayItem() {
        this.displayItem = new ObjectDisplayItem(this.itemConfig.getConfigurationSection("display-item"), this.itemConfig.getConfigurationSection("display-item-conditions"), this);
    }

    private void initReward() {
        if (this.itemConfig.getConfigurationSection("products") == null) {
            this.reward = new ObjectProducts();
            return;
        }
        this.reward = new ObjectProducts(this.itemConfig.getConfigurationSection("products"), this.itemConfig.getString("product-mode", "ANY"), this);
    }

    private void initBuyPrice() {
        if (this.itemConfig.getConfigurationSection("buy-prices") == null) {
            this.buyPrice = this.itemConfig.getConfigurationSection("prices") == null ? new ObjectPrices() : new ObjectPrices(this.itemConfig.getConfigurationSection("prices"), this.itemConfig.getString("price-mode", "ANY"), this, PriceMode.BUY);
            return;
        }
        this.buyPrice = new ObjectPrices(this.itemConfig.getConfigurationSection("buy-prices"), this.itemConfig.getString("price-mode", "ANY"), this, PriceMode.BUY);
    }

    private void initSellPrice() {
        if (this.itemConfig.getConfigurationSection("sell-prices") == null) {
            this.sellPrice = this.itemConfig.getConfigurationSection("prices") == null ? new ObjectPrices() : new ObjectPrices(this.itemConfig.getConfigurationSection("prices"), this.itemConfig.getString("price-mode", "ANY"), this, PriceMode.SELL);
            return;
        }
        this.sellPrice = new ObjectPrices(this.itemConfig.getConfigurationSection("sell-prices"), this.itemConfig.getString("price-mode", "ANY"), this, PriceMode.SELL);
    }

    private void initBuyAction() {
        if (this.itemConfig.getStringListAndMerge("buy-actions").isEmpty()) {
            this.buyAction = new ObjectAction();
            return;
        }
        this.buyAction = new ObjectAction(this.itemConfig.getStringListAndMerge("buy-actions"), this);
    }

    private void initSellAction() {
        if (this.itemConfig.getStringListAndMerge("sell-actions").isEmpty()) {
            this.sellAction = new ObjectAction();
            return;
        }
        this.sellAction = new ObjectAction(this.itemConfig.getStringListAndMerge("sell-actions"), this);
    }

    private void initFailAction() {
        if (this.itemConfig.getStringListAndMerge("fail-actions").isEmpty()) {
            this.failAction = new ObjectAction();
            return;
        }
        this.failAction = new ObjectAction(this.itemConfig.getStringListAndMerge("fail-actions"), this);
    }

    private void initBuyLimit() {
        if (this.itemConfig.getConfigurationSection("limits") == null) {
            this.buyLimit = this.itemConfig.getConfigurationSection("buy-limits") == null ? new ObjectLimit() : new ObjectLimit(this.itemConfig.getConfigurationSection("buy-limits"), this.itemConfig.getConfigurationSection("buy-limits-conditions"), this);
            return;
        }
        this.buyLimit = new ObjectLimit(this.itemConfig.getConfigurationSection("limits"), this.itemConfig.getConfigurationSection("limits-conditions"), this);
    }

    private void initSellLimit() {
        if (this.itemConfig.getConfigurationSection("limits") == null) {
            this.sellLimit = this.itemConfig.getConfigurationSection("sell-limits") == null ? new ObjectLimit() : new ObjectLimit(this.itemConfig.getConfigurationSection("sell-limits"), this.itemConfig.getConfigurationSection("sell-limits-conditions"), this);
            return;
        }
        this.sellLimit = this.buyLimit;
    }

    private void initBuyMoreMenu() {
        ConfigurationSection buyMoreSection = this.itemConfig.getConfigurationSection("buy-more-menu");
        if (buyMoreSection == null) {
            new ObjectMoreMenu(ConfigManager.configManager.getSectionOrDefault("menu.select-more", "menu.buy-more"), this);
        } else {
            new ObjectMoreMenu(buyMoreSection, this);
        }
    }

    private void initBuyCondition() {
        List<String> section = this.itemConfig.getStringList("conditions");
        if (section.isEmpty()) {
            section = this.itemConfig.getStringList("buy-conditions");
        }
        this.buyCondition = new ObjectCondition(section);
    }

    private void initSellCondition() {
        List<String> section = this.itemConfig.getStringList("conditions");
        if (section.isEmpty()) {
            section = this.itemConfig.getStringList("sell-conditions");
        }
        this.sellCondition = new ObjectCondition(section);
    }

    public String getDisplayName(Player player) {
        if (this.itemConfig.getString("display-name") == null) {
            return ItemUtil.getItemName(this.displayItem.getDisplayItem(player));
        }
        return TextUtil.parse(player, this.itemConfig.getString("display-name"));
    }

    public ObjectPrices getBuyPrice() {
        if (this.buyPrice == null) {
            return new ObjectPrices();
        }
        return this.buyPrice;
    }

    public ObjectPrices getSellPrice() {
        if (this.sellPrice == null) {
            return new ObjectPrices();
        }
        return this.sellPrice;
    }

    public ObjectProducts getReward() {
        if (this.reward == null) {
            return new ObjectProducts();
        }
        return this.reward;
    }

    public ObjectAction getBuyAction() {
        return this.buyAction;
    }

    public ObjectAction getSellAction() {
        return this.sellAction;
    }

    public int getPlayerBuyLimit(Player player) {
        ObjectLimit tempVal1 = this.buyLimit;
        if (this.buyLimit == null) {
            return -1;
        }
        return tempVal1.getPlayerLimits(player);
    }

    public int getPlayerSellLimit(Player player) {
        ObjectLimit tempVal1 = this.sellLimit;
        if (this.sellLimit == null) {
            return -1;
        }
        return tempVal1.getPlayerLimits(player);
    }

    public int getServerBuyLimit(Player player) {
        ObjectLimit tempVal1 = this.buyLimit;
        if (this.buyLimit == null) {
            return -1;
        }
        return tempVal1.getServerLimits(player);
    }

    public int getServerSellLimit(Player player) {
        ObjectLimit tempVal1 = this.sellLimit;
        if (this.sellLimit == null) {
            return -1;
        }
        return tempVal1.getServerLimits(player);
    }

    public ConfigurationSection getItemConfig() {
        return this.itemConfig.getSection();
    }

    public String getProduct() {
        return this.itemConfig.getSection().getName();
    }

    public String getShop() {
        return this.shop.getShopName();
    }

    public ObjectShop getShopObject() {
        return this.shop;
    }

    @Override
    public void clickEvent(ClickType type, Player player) {
        String tempVal1;
        if (UltimateShop.useGeyser && CommonUtil.isBedrockPlayer(player)) {
            FormInfoGUI infoGUI = new FormInfoGUI(player, this);
            infoGUI.openGUI(true);
            return;
        }
        boolean b = ConfigManager.configManager.getBoolean("placeholder.click.enabled");
        switch (tempVal1 = ConfigManager.configManager.getClickAction(type)) {
            case "buy": {
                if (!this.buyPrice.empty && BuyProductMethod.startBuy(this.getShop(), this.getProduct(), player, !b).getStatus() != ProductTradeStatus.Status.DONE) {
                    this.failAction.doAction(player, 1, 1, false, type);
                }
                return;
            }
            case "sell": {
                if (!this.sellPrice.empty && SellProductMethod.startSell(this.getShop(), this.getProduct(), player, !b).getStatus() != ProductTradeStatus.Status.DONE) {
                    this.failAction.doAction(player, 1, 1, false, type);
                }
                return;
            }
            case "buy-or-sell": {
                if (this.buyPrice.empty && !this.sellPrice.empty) {
                    if (SellProductMethod.startSell(this.getShop(), this.getProduct(), player, !b).getStatus() != ProductTradeStatus.Status.DONE) {
                        this.failAction.doAction(player, 1, 1, false, type);
                    }
                } else if (!this.buyPrice.empty && BuyProductMethod.startBuy(this.getShop(), this.getProduct(), player, !b).getStatus() != ProductTradeStatus.Status.DONE) {
                    this.failAction.doAction(player, 1, 1, false, type);
                }
                return;
            }
            case "sell-all": {
                if (!this.sellPrice.empty && SellProductMethod.startSell(this.getShop(), this.getProduct(), player, !b, false, true, 1).getStatus() != ProductTradeStatus.Status.DONE) {
                    this.failAction.doAction(player, 1, 1, false, type);
                }
                return;
            }
            case "select-amount": {
                if (this.getBuyMore()) {
                    OpenGUI.openMoreGUI(player, this);
                }
                return;
            }
        }
    }

    @Override
    public ItemStack getDisplayItem(Player player, int multi) {
        if (this.displayItem == null) {
            return new ItemStack(Material.AIR);
        }
        return this.displayItem.getDisplayItem(player, multi);
    }

    public ItemStack getDisplayItem(Player player) {
        if (this.displayItem == null) {
            return new ItemStack(Material.AIR);
        }
        return this.displayItem.getDisplayItem(player);
    }

    public boolean getBuyCondition(Player player) {
        if (this.buyCondition == null) {
            return true;
        }
        return this.buyCondition.getBoolean(player);
    }

    public boolean getSellCondition(Player player) {
        if (this.sellCondition == null) {
            return true;
        }
        return this.sellCondition.getBoolean(player);
    }

    public boolean getBuyMore() {
        return this.itemConfig.getBoolean("buy-more", this.shop.getShopConfig().getBoolean("settings.buy-more", true));
    }

    public List<String> getAddLore() {
        List<String> resultString = this.itemConfig.getStringList("add-lore");
        if (resultString.isEmpty()) {
            return ConfigManager.configManager.getStringList("display-item.add-lore");
        }
        return resultString;
    }

    @Override
    public String toString() {
        return "Shop: " + this.shop.getShopName() + " Product: " + this.itemConfig.getSection().getName();
    }
}

