/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons.subobjects;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.GUI.ModifyDisplayItem;
import cn.superiormc.ultimateshop.methods.Items.BuildItem;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ObjectDisplayItem {
    private final ConfigurationSection section;
    private final ConfigurationSection conditionSection;
    private ObjectItem item;

    public ObjectDisplayItem(ConfigurationSection section, ConfigurationSection conditionSection, ObjectItem item) {
        this.section = section;
        this.conditionSection = conditionSection;
        this.item = item;
    }

    public ObjectDisplayItem(ConfigurationSection section, ConfigurationSection conditionSection) {
        this.section = section;
        this.conditionSection = conditionSection;
    }

    public ItemStack getDisplayItem(Player player) {
        ItemStack addLoreDisplayItem;
        block5: {
            block4: {
                addLoreDisplayItem = null;
                if (this.section != null) break block4;
                if (this.item == null || !ConfigManager.configManager.getBoolean("display-item.auto-set-first-product")) break block5;
                addLoreDisplayItem = this.item.getReward().getDisplayItem(this.section, player, 0, 1);
                break block5;
            }
            if (this.conditionSection == null) {
                String amount = this.section.getString("amount", "1");
                ItemStack displayItem = BuildItem.buildItemStack(player, this.section, MathUtil.doCalculate(TextUtil.withPAPI(amount, player)).intValue(), new String[0]);
                addLoreDisplayItem = displayItem.clone();
            } else {
                for (String conditionID : this.section.getKeys(false)) {
                    ObjectCondition condition;
                    List tempVal1 = this.conditionSection.getStringList(conditionID);
                    if (tempVal1.isEmpty() || this.section.getConfigurationSection(conditionID) == null || !(condition = new ObjectCondition(tempVal1)).getBoolean(player)) continue;
                    String amount = this.section.getString("amount", "1");
                    ItemStack displayItem = BuildItem.buildItemStack(player, this.section.getConfigurationSection(conditionID), MathUtil.doCalculate(TextUtil.withPAPI(amount, player)).intValue(), new String[0]);
                    addLoreDisplayItem = displayItem.clone();
                    break;
                }
            }
        }
        if (addLoreDisplayItem == null) {
            addLoreDisplayItem = new ItemStack(Material.AIR);
        }
        return addLoreDisplayItem;
    }

    public ItemStack getDisplayItem(Player player, int multi) {
        ItemStack addLoreDisplayItem = this.getDisplayItem(player);
        if (this.item != null) {
            if (this.section != null && !this.section.getBoolean("modify-lore", true)) {
                return addLoreDisplayItem;
            }
            return ModifyDisplayItem.modifyItem(player, multi, addLoreDisplayItem, this.item, false);
        }
        return addLoreDisplayItem;
    }
}

