/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons.subobjects;

import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectItemConfig {
    private ObjectItem item;
    private final ConfigurationSection section;
    private final ConfigurationSection shopSection;

    public ObjectItemConfig(ObjectItem objectItem, ConfigurationSection section) {
        this.item = objectItem;
        this.section = section;
        this.shopSection = objectItem.getShopObject().getShopConfig().getConfigurationSection("general-configs");
    }

    public ConfigurationSection getConfigurationSection(String key) {
        if (this.shopSection == null) {
            return this.section.getConfigurationSection(key);
        }
        ConfigurationSection tempVal1 = this.section.getConfigurationSection(key);
        if (tempVal1 == null) {
            return this.shopSection.getConfigurationSection(key);
        }
        return tempVal1;
    }

    public String getString(String key) {
        if (this.shopSection == null) {
            return this.section.getString(key);
        }
        String tempVal1 = this.section.getString(key);
        if (tempVal1 == null) {
            return this.shopSection.getString(key);
        }
        return tempVal1;
    }

    public String getString(String key, String defaultValue) {
        if (this.shopSection == null) {
            return this.section.getString(key, defaultValue);
        }
        String tempVal1 = this.section.getString(key);
        if (tempVal1 == null) {
            return this.shopSection.getString(key, defaultValue);
        }
        return tempVal1;
    }

    public List<String> getStringList(String path) {
        if (this.shopSection == null) {
            return this.section.getStringList(path);
        }
        List tempVal1 = this.section.getStringList(path);
        if (tempVal1.isEmpty()) {
            return this.shopSection.getStringList(path);
        }
        return tempVal1;
    }

    public List<String> getStringListAndMerge(String path) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.section.getStringList(path));
        if (this.shopSection != null) {
            result.addAll(this.shopSection.getStringList(path));
        }
        return result;
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        if (this.shopSection == null) {
            return this.section.getBoolean(path, defaultValue);
        }
        if (this.section.contains(path)) {
            return this.section.getBoolean(path);
        }
        return this.shopSection.getBoolean(path, defaultValue);
    }

    public ConfigurationSection getSection() {
        return this.section;
    }
}

