/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.caches;

import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.BungeeCordManager;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class ObjectRandomPlaceholderCache {
    private String nowValue = null;
    private LocalDateTime refreshDoneTime = null;
    private final ObjectRandomPlaceholder placeholder;

    public ObjectRandomPlaceholderCache(ObjectRandomPlaceholder placeholder) {
        this.placeholder = placeholder;
        this.setRefreshTime();
    }

    public ObjectRandomPlaceholderCache(ObjectRandomPlaceholder placeholder, String nowValue, LocalDateTime refreshDoneTime) {
        this.placeholder = placeholder;
        this.nowValue = nowValue;
        this.refreshDoneTime = refreshDoneTime;
    }

    public ObjectRandomPlaceholder getPlaceholder() {
        return this.placeholder;
    }

    public LocalDateTime getRefreshDoneTime() {
        return this.refreshDoneTime;
    }

    public void removeRefreshDoneTime() {
        this.refreshDoneTime = null;
    }

    public String getNowValue() {
        return this.getNowValue(true, false);
    }

    public String getNowValue(boolean disable) {
        return this.getNowValue(true, disable);
    }

    public String getNowValue(boolean needRefresh, boolean disable) {
        if (needRefresh) {
            this.setRefreshTime(disable);
        }
        return this.nowValue;
    }

    public void setRefreshTime() {
        this.setRefreshTime(false);
    }

    public void setRefreshTime(boolean notUseBungee) {
        String mode = this.placeholder.getMode();
        String time = this.placeholder.getConfig().getString("reset-time");
        if (mode == null || time == null) {
            if (this.nowValue == null) {
                this.setPlaceholder(notUseBungee);
            }
            return;
        }
        if (mode.equals("ONCE")) {
            this.setPlaceholder(notUseBungee);
            return;
        }
        boolean needRefresh = this.nowValue == null || this.refreshDoneTime == null || !this.refreshDoneTime.isAfter(LocalDateTime.now());
        for (ObjectRandomPlaceholder tempVal1 : this.placeholder.getNotSameAs()) {
            if (tempVal1.equals(this.getPlaceholder()) || !tempVal1.getNowValue().equals(this.nowValue)) continue;
            needRefresh = true;
        }
        if (needRefresh) {
            if (mode.equals("TIMED")) {
                this.refreshDoneTime = this.getTimedRefreshTime(time);
                this.setPlaceholder(notUseBungee);
            } else if (mode.equals("TIMER")) {
                this.refreshDoneTime = this.getTimerRefreshTime(time);
                this.setPlaceholder(notUseBungee);
            }
        }
    }

    public void setPlaceholder(boolean notUseBungee) {
        this.setPlaceholder(this.placeholder.getNewValue(), notUseBungee);
    }

    public void setPlaceholder(String element, boolean notUseBungee) {
        this.nowValue = element;
        if (this.placeholder.getMode().equals("TIMED") || this.placeholder.getMode().equals("TIMER")) {
            ServerCache.serverCache.setRandomPlaceholderCache(this.placeholder.getID(), CommonUtil.timeToString(this.refreshDoneTime), this.nowValue);
        }
        if (!notUseBungee && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.placeholder.getID(), this.nowValue, CommonUtil.timeToString(this.refreshDoneTime));
        }
    }

    private LocalDateTime getTimedRefreshTime(String time) {
        String tempVal1 = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        tempVal1 = tempVal1 + " " + time;
        LocalDateTime refreshResult = CommonUtil.stringToTime(tempVal1);
        if (LocalDateTime.now().isAfter(refreshResult)) {
            refreshResult = refreshResult.plusDays(1L);
        }
        return refreshResult;
    }

    private LocalDateTime getTimerRefreshTime(String time) {
        LocalDateTime refreshResult = LocalDateTime.now();
        refreshResult = refreshResult.plusHours(Long.parseLong(time.split(":")[0]));
        refreshResult = refreshResult.plusMinutes(Long.parseLong(time.split(":")[1]));
        refreshResult = refreshResult.plusSeconds(Long.parseLong(time.split(":")[2]));
        return refreshResult;
    }
}

