/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.caches;

import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.managers.BungeeCordManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bukkit.Bukkit;

public class ObjectUseTimesCache {
    private int buyUseTimes;
    private int sellUseTimes;
    private LocalDateTime lastBuyTime = null;
    private LocalDateTime lastSellTime = null;
    private LocalDateTime cooldownBuyTime = null;
    private LocalDateTime cooldownSellTime = null;
    private final ObjectItem product;
    private final ServerCache cache;

    public ObjectUseTimesCache(ServerCache cache, int buyUseTimes, int sellUseTimes, String lastBuyTime, String lastSellTime, String cooldownBuyTime, String cooldownSellTime, ObjectItem product) {
        this.cache = cache;
        this.buyUseTimes = buyUseTimes;
        if (lastBuyTime != null) {
            this.lastBuyTime = CommonUtil.stringToTime(lastBuyTime);
        }
        this.sellUseTimes = sellUseTimes;
        if (lastSellTime != null) {
            this.lastSellTime = CommonUtil.stringToTime(lastSellTime);
        }
        if (cooldownBuyTime != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cSet cooldown time to " + product);
            }
            this.cooldownBuyTime = CommonUtil.stringToTime(cooldownBuyTime);
        }
        this.sellUseTimes = sellUseTimes;
        if (cooldownSellTime != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cSet cooldown time to " + product);
            }
            this.cooldownSellTime = CommonUtil.stringToTime(cooldownSellTime);
        }
        this.product = product;
    }

    public int getBuyUseTimes() {
        return this.buyUseTimes;
    }

    public int getSellUseTimes() {
        return this.sellUseTimes;
    }

    public void setBuyUseTimes(int i) {
        this.setBuyUseTimes(i, false);
    }

    public void setBuyUseTimes(int i, boolean notUseBungee) {
        this.buyUseTimes = i;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "buy-times", String.valueOf(i));
        }
    }

    public void setSellUseTimes(int i) {
        this.setSellUseTimes(i, false);
    }

    public void setSellUseTimes(int i, boolean notUseBungee) {
        this.sellUseTimes = i;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "sell-times", String.valueOf(i));
        }
    }

    public void setLastBuyTime(LocalDateTime time) {
        this.setLastBuyTime(time, false);
    }

    public void setLastBuyTime(LocalDateTime time, boolean notUseBungee) {
        this.lastBuyTime = time;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "last-buy-time", CommonUtil.timeToString(time));
        }
    }

    public void setLastSellTime(LocalDateTime time) {
        this.setLastSellTime(time, false);
    }

    public void setLastSellTime(LocalDateTime time, boolean notUseBungee) {
        this.lastSellTime = time;
        if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "last-sell-time", CommonUtil.timeToString(time));
        }
    }

    public void setCooldownBuyTime() {
        this.setCooldownBuyTime(false);
    }

    public void setCooldownBuyTime(boolean notUseBungee) {
        String mode = this.product.getItemConfig().getString("buy-cooldown-mode");
        String tempVal1 = this.product.getItemConfig().getString("buy-cooldown-time");
        if (mode == null || tempVal1 == null) {
            return;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cSet cooldown time to " + this.product);
        }
        if (this.cooldownBuyTime == null || !this.cooldownBuyTime.isAfter(LocalDateTime.now())) {
            if (mode.equals("TIMED")) {
                this.cooldownBuyTime = this.getTimedBuyRefreshTime(tempVal1);
                if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-buy-time", null);
                }
            } else if (mode.equals("TIMER")) {
                this.cooldownBuyTime = this.getTimerBuyRefreshTime(tempVal1);
                if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-buy-time", null);
                }
            }
        }
    }

    public void setCooldownSellTime() {
        this.setCooldownSellTime(false);
    }

    public void setCooldownSellTime(boolean notUseBungee) {
        String mode = this.product.getItemConfig().getString("sell-cooldown-mode");
        String tempVal1 = this.product.getItemConfig().getString("sell-cooldown-time");
        if (mode == null || tempVal1 == null) {
            return;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cSet cooldown time to " + this.product);
        }
        if (this.cooldownSellTime == null || !this.cooldownSellTime.isAfter(LocalDateTime.now())) {
            if (mode.equals("TIMED")) {
                this.cooldownSellTime = this.getTimedSellRefreshTime(tempVal1);
                if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-sell-time", null);
                }
            } else if (mode.equals("TIMER")) {
                this.cooldownSellTime = this.getTimerSellRefreshTime(tempVal1);
                if (!notUseBungee && this.cache.server && BungeeCordManager.bungeeCordManager != null) {
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-sell-time", null);
                }
            }
        }
    }

    public String getLastBuyTime() {
        if (this.lastBuyTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastBuyTime);
    }

    public String getLastSellTime() {
        if (this.lastSellTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastSellTime);
    }

    public String getCooldownBuyTime() {
        if (this.cooldownBuyTime == null) {
            return null;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cCooldown time: " + this.cooldownBuyTime);
        }
        return CommonUtil.timeToString(this.cooldownBuyTime);
    }

    public String getCooldownSellTime() {
        if (this.cooldownSellTime == null) {
            return null;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cCooldown time: " + this.cooldownSellTime);
        }
        return CommonUtil.timeToString(this.cooldownSellTime);
    }

    public LocalDateTime getCooldownBuyRefreshTime() {
        return this.cooldownBuyTime;
    }

    public LocalDateTime getBuyRefreshTime() {
        if (this.lastBuyTime == null) {
            return LocalDateTime.now().withYear(2999);
        }
        String mode = this.product.getItemConfig().getString("buy-limits-reset-mode", ConfigManager.configManager.getString("use-times.default-reset-mode", new String[0]));
        String tempVal1 = this.product.getItemConfig().getString("buy-limits-reset-time", ConfigManager.configManager.getString("use-times.default-reset-time", new String[0]));
        if (mode.equals("TIMED")) {
            return this.getTimedBuyRefreshTime(tempVal1);
        }
        if (mode.equals("TIMER")) {
            return this.getTimerBuyRefreshTime(tempVal1);
        }
        return LocalDateTime.now().withYear(2999);
    }

    public LocalDateTime getCooldownSellRefreshTime() {
        return this.cooldownSellTime;
    }

    public LocalDateTime getSellRefreshTime() {
        if (this.lastSellTime == null) {
            return LocalDateTime.now().withYear(2999);
        }
        String mode = this.product.getItemConfig().getString("sell-limits-reset-mode", ConfigManager.configManager.getString("use-times.default-reset-mode", new String[0]));
        String tempVal1 = this.product.getItemConfig().getString("sell-limits-reset-time", ConfigManager.configManager.getString("use-times.default-reset-time", new String[0]));
        if (mode.equals("TIMED")) {
            return this.getTimedSellRefreshTime(tempVal1);
        }
        if (mode.equals("TIMER")) {
            return this.getTimerSellRefreshTime(tempVal1);
        }
        return LocalDateTime.now().withYear(2999);
    }

    public String getBuyCooldownTimeDisplayName() {
        LocalDateTime tempVal1 = this.getCooldownBuyRefreshTime();
        if (tempVal1 == null || !tempVal1.isAfter(LocalDateTime.now())) {
            return ConfigManager.configManager.getString("placeholder.cooldown.now", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.cooldown.format", new String[0]));
    }

    public String getBuyRefreshTimeDisplayName() {
        LocalDateTime tempVal1 = this.getBuyRefreshTime();
        if (tempVal1 == null || tempVal1.getYear() == 2999) {
            return ConfigManager.configManager.getString("placeholder.refresh.never", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    public String getSellCooldownTimeDisplayName() {
        LocalDateTime tempVal1 = this.getCooldownSellRefreshTime();
        if (tempVal1 == null || !tempVal1.isAfter(LocalDateTime.now())) {
            return ConfigManager.configManager.getString("placeholder.cooldown.now", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.cooldown.format", new String[0]));
    }

    public String getSellRefreshTimeDisplayName() {
        LocalDateTime tempVal1 = this.getSellRefreshTime();
        if (tempVal1 == null || tempVal1.getYear() == 2999) {
            return ConfigManager.configManager.getString("placeholder.refresh.never", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    private LocalDateTime getTimedBuyRefreshTime(String time) {
        String tempVal1 = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDateTime refreshResult = CommonUtil.stringToTime(tempVal1 = tempVal1 + " " + time);
        if (this.lastBuyTime.isAfter(refreshResult)) {
            refreshResult = refreshResult.plusDays(1L);
        }
        return refreshResult;
    }

    private LocalDateTime getTimedSellRefreshTime(String time) {
        String tempVal1 = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDateTime refreshResult = CommonUtil.stringToTime(tempVal1 = tempVal1 + " " + time);
        if (this.lastSellTime.isAfter(refreshResult)) {
            refreshResult = refreshResult.plusDays(1L);
        }
        return refreshResult;
    }

    private LocalDateTime getTimerBuyRefreshTime(String time) {
        LocalDateTime refreshResult = this.lastBuyTime;
        refreshResult = refreshResult.plusHours(Long.parseLong(time.split(":")[0]));
        refreshResult = refreshResult.plusMinutes(Long.parseLong(time.split(":")[1]));
        refreshResult = refreshResult.plusSeconds(Long.parseLong(time.split(":")[2]));
        return refreshResult;
    }

    private LocalDateTime getTimerSellRefreshTime(String time) {
        LocalDateTime refreshResult = this.lastSellTime;
        refreshResult = refreshResult.plusHours(Long.parseLong(time.split(":")[0]));
        refreshResult = refreshResult.plusMinutes(Long.parseLong(time.split(":")[1]));
        refreshResult = refreshResult.plusSeconds(Long.parseLong(time.split(":")[2]));
        return refreshResult;
    }
}

