/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.hooks.PriceHook;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.methods.Items.BuildItem;
import cn.superiormc.ultimateshop.objects.items.AbstractThings;
import cn.superiormc.ultimateshop.objects.items.GiveItemStack;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.items.ThingType;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectSinglePrice;
import cn.superiormc.ultimateshop.objects.items.prices.PriceMode;
import cn.superiormc.ultimateshop.objects.items.products.ObjectSingleProduct;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectDisplayPlaceholder;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSingleThing
implements Comparable<AbstractSingleThing> {
    public ThingType type;
    public ConfigurationSection singleSection;
    public ObjectCondition condition;
    public boolean empty;
    private final ObjectDisplayPlaceholder displayPlaceholder;
    private String id;
    public AbstractThings things;

    public AbstractSingleThing() {
        this.initType(null);
        this.empty = true;
        this.displayPlaceholder = new ObjectDisplayPlaceholder(this);
    }

    public AbstractSingleThing(String id, AbstractThings things) {
        this.id = id;
        this.singleSection = things.section.getConfigurationSection(id);
        if (this.singleSection != null && this.singleSection.contains("custom-type")) {
            this.initType(ConfigManager.configManager.config.getConfigurationSection("prices." + this.singleSection.getString("custom-type")));
        } else {
            this.initType(this.singleSection);
        }
        this.empty = false;
        this.displayPlaceholder = new ObjectDisplayPlaceholder(this);
    }

    private void initType(ConfigurationSection section) {
        this.type = section == null ? ThingType.UNKNOWN : (section.contains("hook-plugin") && section.contains("hook-item") ? ThingType.HOOK_ITEM : (section.contains("match-item") && CommonUtil.checkPluginLoad("MythicChanger") ? ThingType.MATCH_ITEM : (section.contains("material") ? ThingType.VANILLA_ITEM : (section.contains("economy-plugin") ? ThingType.HOOK_ECONOMY : (section.contains("economy-type") && !section.contains("economy-plugin") ? ThingType.VANILLA_ECONOMY : ThingType.FREE)))));
    }

    protected void initCondition() {
        List conditions = null;
        if (this instanceof ObjectSinglePrice) {
            ObjectPrices objectPrices = (ObjectPrices)this.things;
            conditions = objectPrices.getPriceMode() == PriceMode.BUY ? this.things.section.getStringList("buy-prices-conditions." + this.id) : this.things.section.getStringList("sell-prices-conditions." + this.id);
        } else if (this instanceof ObjectSingleProduct) {
            conditions = this.things.section.getStringList("products-conditions." + this.id);
        }
        if (conditions == null || conditions.isEmpty()) {
            conditions = this.singleSection.getStringList("conditions");
        }
        this.condition = conditions.isEmpty() ? new ObjectCondition() : new ObjectCondition(conditions);
    }

    public GiveItemStack playerCanGive(Player player, double cost) {
        if (this.singleSection == null) {
            return new GiveItemStack(this);
        }
        switch (this.type) {
            case VANILLA_ITEM: 
            case HOOK_ITEM: 
            case MATCH_ITEM: {
                if (ConfigManager.configManager.getString("give-item.give-method", "BUKKIT").equalsIgnoreCase("BUKKIT")) {
                    return this.getItemThing(this.singleSection, player, cost, true);
                }
                return this.getItemThing(this.singleSection, player, cost, false);
            }
            case HOOK_ECONOMY: 
            case VANILLA_ECONOMY: {
                return new GiveItemStack(cost, this);
            }
        }
        return new GiveItemStack(this);
    }

    public boolean getCondition(Player player) {
        if (this.condition == null) {
            return true;
        }
        return this.condition.getBoolean(player);
    }

    public double playerHasAmount(Inventory inventory, Player player) {
        return this.playerHasAmount(inventory, this.singleSection, player);
    }

    public double playerHasAmount(Inventory inventory, ConfigurationSection section, Player player) {
        if (section == null) {
            return 0.0;
        }
        switch (this.type) {
            case HOOK_ITEM: {
                String pluginName = section.getString("hook-plugin", "");
                String itemID = section.getString("hook-item", "");
                if (pluginName.equals("MMOItems") && !itemID.contains(";;")) {
                    itemID = section.getString("hook-item-type") + ";;" + itemID;
                } else if (pluginName.equals("EcoArmor") && !itemID.contains(";;")) {
                    itemID = itemID + ";;" + section.getString("hook-item-type");
                }
                return PriceHook.getItemAmount(inventory, pluginName, itemID);
            }
            case VANILLA_ITEM: {
                ItemStack tempVal1 = this.getItemThing(section, player, 1.0, true).getTargetItem();
                if (tempVal1 == null) {
                    return 0.0;
                }
                return PriceHook.getItemAmount(inventory, tempVal1);
            }
            case MATCH_ITEM: {
                return PriceHook.getItemAmount(inventory, section);
            }
            case HOOK_ECONOMY: {
                return PriceHook.getEconomyAmount(player, section.getString("economy-plugin"), section.getString("economy-type", "default"));
            }
            case VANILLA_ECONOMY: {
                return PriceHook.getEconomyAmount(player, section.getString("economy-type"));
            }
            case UNKNOWN: {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cThere is something wrong in your shop configs!");
                return 0.0;
            }
        }
        return 0.0;
    }

    public boolean playerHasEnough(Inventory inventory, Player player, boolean take, double cost) {
        return this.playerHasEnough(inventory, this.singleSection, player, take, cost);
    }

    public boolean playerHasEnough(Inventory inventory, ConfigurationSection section, Player player, boolean take, double cost) {
        if (section == null) {
            return false;
        }
        if (cost < 0.0) {
            return false;
        }
        switch (this.type) {
            case HOOK_ITEM: {
                String pluginName = section.getString("hook-plugin", "");
                String itemID = section.getString("hook-item", "");
                if (pluginName.equals("MMOItems") && !itemID.contains(";;")) {
                    itemID = section.getString("hook-item-type") + ";;" + itemID;
                } else if (pluginName.equals("EcoArmor") && !itemID.contains(";;")) {
                    itemID = itemID + ";;" + section.getString("hook-item-type");
                }
                return PriceHook.getPrice(inventory, player, pluginName, itemID, (int)cost, take);
            }
            case VANILLA_ITEM: {
                ItemStack itemStack = this.getItemThing(section, player, 1.0, true).getTargetItem();
                if (itemStack == null) {
                    return false;
                }
                return PriceHook.getPrice(inventory, player, itemStack, (int)cost, take);
            }
            case MATCH_ITEM: {
                return PriceHook.getPrice(inventory, player, section, (int)cost, take);
            }
            case HOOK_ECONOMY: {
                return PriceHook.getPrice(player, section.getString("economy-plugin"), section.getString("economy-type", "default"), cost, take);
            }
            case VANILLA_ECONOMY: {
                return PriceHook.getPrice(player, section.getString("economy-type"), (int)cost, take);
            }
            case UNKNOWN: {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cThere is something wrong in your shop configs!");
                return false;
            }
        }
        return false;
    }

    public GiveItemStack getItemThing(ConfigurationSection section, Player player, double cost, boolean displayOnly) {
        if (section == null) {
            if (this.singleSection == null) {
                return new GiveItemStack(this);
            }
            section = this.singleSection;
        }
        int amount = (int)cost;
        ItemStack targetItem = BuildItem.buildItemStack(player, section, 1, new String[0]);
        if (targetItem == null) {
            return new GiveItemStack(this);
        }
        ItemStack displayItem = targetItem.clone();
        displayItem.setAmount((int)cost);
        if (displayOnly) {
            return new GiveItemStack(targetItem, displayItem, this);
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int leftAmount = 0;
        int emptySlots = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item == null || item.getType().isAir()) {
                ++emptySlots;
                continue;
            }
            if (!item.isSimilar(targetItem) || (leftAmount = leftAmount + targetItem.getMaxStackSize() - item.getAmount()) >= 0) continue;
            leftAmount = 0;
        }
        int requiredSlots = 0;
        if (amount > leftAmount) {
            requiredSlots = (int)Math.ceil((double)(amount - leftAmount) / (double)targetItem.getMaxStackSize());
            boolean first = true;
            for (int i = 0; i < requiredSlots; ++i) {
                ItemStack tempVal1;
                if (first) {
                    tempVal1 = targetItem.clone();
                    tempVal1.setAmount((int)cost - (requiredSlots - 1) * targetItem.getMaxStackSize());
                    result.add(tempVal1);
                    first = false;
                    continue;
                }
                tempVal1 = targetItem.clone();
                tempVal1.setAmount(targetItem.getMaxStackSize());
                result.add(tempVal1);
            }
        } else {
            result.add(displayItem);
        }
        return new GiveItemStack(result, targetItem, displayItem, emptySlots >= requiredSlots, this);
    }

    public abstract String getDisplayName(int var1, BigDecimal var2, boolean var3);

    public String getId() {
        return this.id;
    }

    public ObjectDisplayPlaceholder getDisplayPlaceholder() {
        return this.displayPlaceholder;
    }

    @Override
    public int compareTo(@NotNull AbstractSingleThing otherThing) {
        int len1 = this.getId().length();
        int len2 = otherThing.getId().length();
        int minLength = Math.min(len1, len2);
        for (int i = 0; i < minLength; ++i) {
            char c2;
            char c1 = this.getId().charAt(i);
            if (c1 == (c2 = otherThing.getId().charAt(i))) continue;
            if (Character.isDigit(c1) && Character.isDigit(c2)) {
                return Integer.compare(Integer.parseInt(this.getId().substring(i)), Integer.parseInt(otherThing.getId().substring(i)));
            }
            return c1 - c2;
        }
        return len1 - len2;
    }
}

