/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.GiveItemStack;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.ThingMode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class AbstractThings {
    public ThingMode mode;
    public ConfigurationSection section;
    public boolean empty;
    private ObjectItem item;

    public AbstractThings() {
        this.mode = ThingMode.UNKNOWN;
        this.empty = true;
    }

    public AbstractThings(ConfigurationSection section, String mode, ObjectItem item) {
        this.initThingMode(mode);
        this.section = section;
        this.empty = false;
        this.item = item;
    }

    public ThingMode getMode() {
        return this.mode;
    }

    public abstract GiveResult giveSingleThing(Player var1, int var2, int var3);

    public boolean giveThing(Player player, Map<AbstractSingleThing, BigDecimal> result) {
        boolean resultBoolean = true;
        ArrayList<GiveItemStack> giveItemStacks = new ArrayList<GiveItemStack>();
        for (AbstractSingleThing singleThing : result.keySet()) {
            GiveItemStack giveItemStack = singleThing.playerCanGive(player, result.get(singleThing).doubleValue());
            giveItemStacks.add(giveItemStack);
            if (giveItemStack.isCanGive()) continue;
            resultBoolean = false;
        }
        if (!resultBoolean) {
            return false;
        }
        for (GiveItemStack giveItemStack : giveItemStacks) {
            giveItemStack.giveToPlayer(player);
        }
        return true;
    }

    public abstract TakeResult takeSingleThing(Inventory var1, Player var2, int var3, int var4, boolean var5);

    public void takeThing(Inventory inventory, Player player, Map<AbstractSingleThing, BigDecimal> result) {
        for (AbstractSingleThing singleThing : result.keySet()) {
            singleThing.playerHasEnough(inventory, player, true, result.get(singleThing).doubleValue());
        }
    }

    private void initThingMode(String mode) {
        switch (mode.toUpperCase()) {
            case "ANY": {
                this.mode = ThingMode.ANY;
                break;
            }
            case "ALL": {
                this.mode = ThingMode.ALL;
                break;
            }
            case "CLASSIC": 
            case "CLASSIC_ALL": {
                this.mode = ThingMode.CLASSIC_ALL;
                break;
            }
            case "CLASSIC_ANY": {
                this.mode = ThingMode.CLASSIC_ANY;
                break;
            }
            default: {
                this.mode = ThingMode.UNKNOWN;
            }
        }
    }

    public ObjectItem getItem() {
        return this.item;
    }
}

