/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class ObjectCondition {
    private final List<String> condition;

    public ObjectCondition() {
        this.condition = new ArrayList<String>();
        this.condition.add("none");
    }

    public ObjectCondition(List<String> condition) {
        this.condition = condition;
    }

    public boolean getBoolean(Player player) {
        if (player == null) {
            return false;
        }
        boolean conditionTrueOrFasle = true;
        block2: for (String singleCondition : this.condition) {
            if (singleCondition.equals("none")) {
                return true;
            }
            if (singleCondition.startsWith("world: ")) {
                int i = 0;
                for (String str : singleCondition.substring(7).split(";;")) {
                    if (str.equals(player.getWorld().getName())) break;
                    ++i;
                }
                if (i != singleCondition.substring(7).split(";;").length) continue;
                conditionTrueOrFasle = false;
                break;
            }
            if (singleCondition.startsWith("permission: ")) {
                for (String str : singleCondition.substring(12).split(";;")) {
                    if (player.hasPermission(str)) continue;
                    conditionTrueOrFasle = false;
                    continue block2;
                }
                continue;
            }
            if (!singleCondition.startsWith("placeholder: ")) continue;
            try {
                if (singleCondition.split(";;").length == 3) {
                    String[] conditionString = singleCondition.substring(13).split(";;");
                    String placeholder = TextUtil.withPAPI(conditionString[0], player);
                    String conditionValue = conditionString[1];
                    String value = conditionString[2];
                    if (conditionValue.equals("==") && !placeholder.equals(value)) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals("!=") && placeholder.equals(value)) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals("*=") && !placeholder.contains(value)) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals("!*=") && placeholder.contains(value)) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals(">=") && !(Double.parseDouble(placeholder) >= Double.parseDouble(value))) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals(">") && !(Double.parseDouble(placeholder) > Double.parseDouble(value))) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals("<=") && !(Double.parseDouble(placeholder) <= Double.parseDouble(value))) {
                        conditionTrueOrFasle = false;
                    } else if (conditionValue.equals("<") && !(Double.parseDouble(placeholder) < Double.parseDouble(value))) {
                        conditionTrueOrFasle = false;
                    } else {
                        if (!conditionValue.equals("=") || Double.parseDouble(placeholder) == Double.parseDouble(value)) continue;
                        conditionTrueOrFasle = false;
                    }
                    break;
                }
                ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Your placeholder condition in totem configs can not being correctly load.");
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Your placeholder condition in totem configs can not being correctly load.");
                return false;
            }
        }
        return conditionTrueOrFasle;
    }
}

