/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectLimit {
    private ConfigurationSection limitSection;
    private ConfigurationSection conditionsSection;
    private ObjectItem item;

    public ObjectLimit() {
    }

    public ObjectLimit(ConfigurationSection limitSection, ConfigurationSection conditionsSection, ObjectItem item) {
        this.limitSection = limitSection;
        this.conditionsSection = conditionsSection;
        this.item = item;
    }

    public int getPlayerLimits(Player player) {
        if (this.limitSection == null) {
            return -1;
        }
        if (this.conditionsSection == null) {
            return this.checkLimitValue(player, "default");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String conditionName : this.limitSection.getKeys(false)) {
            if (conditionName.equals("default") || conditionName.equals("global") || !this.checkLimitsCondition(conditionName, player)) continue;
            result.add(this.checkLimitValue(player, conditionName));
        }
        result.add(this.checkLimitValue(player, "default"));
        return (Integer)Collections.max(result);
    }

    public int getServerLimits(Player player) {
        if (this.limitSection == null) {
            return -1;
        }
        int tempVal2 = -1;
        String tempVal1 = this.limitSection.getString("global", "-1");
        if (!tempVal1.equals("-1")) {
            tempVal2 = this.checkLimitValue(player, "global");
        }
        return tempVal2;
    }

    private boolean checkLimitsCondition(String conditionName, Player player) {
        if (!this.conditionsSection.getStringList(conditionName).isEmpty()) {
            List condition = this.conditionsSection.getStringList(conditionName);
            ObjectCondition tempVal1 = condition.isEmpty() ? new ObjectCondition() : new ObjectCondition(condition);
            return tempVal1.getBoolean(player);
        }
        return false;
    }

    private int checkLimitValue(Player player, String path) {
        int tempVal2 = -1;
        String tempVal1 = this.limitSection.getString(path, "-1");
        if (!tempVal1.equals("-1")) {
            if (this.item != null && ConfigManager.configManager.getBoolean("placeholder.data.can-used-in-amount")) {
                int playerBuyTimes = 0;
                int playerSellTimes = 0;
                int serverBuyTimes = 0;
                int serverSellTimes = 0;
                ObjectUseTimesCache tempVal3 = CacheManager.cacheManager.getPlayerCache(player).getUseTimesCache().get(this.item);
                ObjectUseTimesCache tempVal4 = CacheManager.cacheManager.serverCache.getUseTimesCache().get(this.item);
                if (tempVal3 != null) {
                    playerBuyTimes = tempVal3.getBuyUseTimes();
                    playerSellTimes = tempVal3.getSellUseTimes();
                }
                if (tempVal4 != null) {
                    serverBuyTimes = tempVal4.getBuyUseTimes();
                    serverSellTimes = tempVal4.getSellUseTimes();
                }
                tempVal1 = CommonUtil.modifyString(tempVal1, "buy-times-player", String.valueOf(playerBuyTimes), "sell-times-player", String.valueOf(playerSellTimes), "buy-times-server", String.valueOf(serverBuyTimes), "sell-times-server", String.valueOf(serverSellTimes));
            }
            tempVal2 = MathUtil.doCalculate(TextUtil.withPAPI(tempVal1, player)).intValue();
        }
        return tempVal2;
    }
}

