/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.prices;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.AbstractThings;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.ThingMode;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectSinglePrice;
import cn.superiormc.ultimateshop.objects.items.prices.PriceMode;
import cn.superiormc.ultimateshop.objects.items.prices.PriceType;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectDisplayPlaceholder;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ObjectPrices
extends AbstractThings {
    public Collection<ObjectSinglePrice> singlePrices = new TreeSet<ObjectSinglePrice>();
    private PriceMode priceMode;

    public ObjectPrices() {
        this.empty = true;
    }

    public ObjectPrices(ConfigurationSection section, String mode, ObjectItem item, PriceMode priceMode) {
        super(section, mode, item);
        this.empty = false;
        this.priceMode = priceMode;
        this.initSinglePrices();
    }

    public void initSinglePrices() {
        for (String s : this.section.getKeys(false)) {
            if (this.section.getConfigurationSection(s) == null) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get prices section in your shop config!!");
                this.singlePrices.add(new ObjectSinglePrice());
                continue;
            }
            this.singlePrices.add(new ObjectSinglePrice(s, this));
        }
    }

    private Collection<ObjectSinglePrice> getTargetPrices(Inventory inventory, Player player, int times, int amount, boolean giveOrTake) {
        switch (this.mode) {
            case ANY: 
            case CLASSIC_ANY: {
                TreeSet<ObjectSinglePrice> confirmedResult = new TreeSet<ObjectSinglePrice>();
                TreeSet<ObjectSinglePrice> maybeResult = new TreeSet<ObjectSinglePrice>();
                Map<ObjectSinglePrice, PriceType> priceMap = this.getAllPrices(player, times, amount);
                for (ObjectSinglePrice tempVal1 : priceMap.keySet()) {
                    BigDecimal cost = this.getAmount(player, times, amount).get(tempVal1);
                    if (!tempVal1.getCondition(player)) continue;
                    if (giveOrTake || tempVal1.playerHasEnough(inventory, player, false, cost.doubleValue())) {
                        if (priceMap.get(tempVal1) != PriceType.FIRST) continue;
                        confirmedResult.add(tempVal1);
                        continue;
                    }
                    if (priceMap.get(tempVal1) != PriceType.FIRST) continue;
                    maybeResult.add(tempVal1);
                }
                if (confirmedResult.isEmpty() && maybeResult.isEmpty()) {
                    maybeResult.add(new ObjectSinglePrice());
                    return maybeResult;
                }
                if (confirmedResult.isEmpty()) {
                    return maybeResult;
                }
                return confirmedResult;
            }
            case ALL: 
            case CLASSIC_ALL: {
                return this.getAllPrices(player, times, amount).keySet();
            }
        }
        return new TreeSet<ObjectSinglePrice>();
    }

    private Map<ObjectSinglePrice, PriceType> getAllPrices(Player player, int times, int amount) {
        TreeMap<ObjectSinglePrice, PriceType> applyThings = new TreeMap<ObjectSinglePrice, PriceType>();
        switch (this.mode) {
            case CLASSIC_ANY: 
            case CLASSIC_ALL: {
                for (ObjectSinglePrice tempVal1 : this.singlePrices) {
                    if (!tempVal1.getCondition(player) || !tempVal1.getApplyCostMap().containsKey(times) && (!tempVal1.getApplyCostMap().isEmpty() || times < tempVal1.getStartApply() || times > tempVal1.getEndApply())) continue;
                    if (applyThings.isEmpty()) {
                        applyThings.put(tempVal1, PriceType.FIRST);
                        continue;
                    }
                    applyThings.put(tempVal1, PriceType.NOT_FIRST);
                }
                break;
            }
            case ANY: 
            case ALL: {
                HashSet<Integer> confirmedAmount = new HashSet<Integer>();
                for (int i = 0; i < amount; ++i) {
                    for (ObjectSinglePrice tempVal1 : this.singlePrices) {
                        if (!tempVal1.getCondition(player) || !tempVal1.getApplyCostMap().containsKey(times + i) && (!tempVal1.getApplyCostMap().isEmpty() || times + i < tempVal1.getStartApply() || times + i > tempVal1.getEndApply())) continue;
                        if (!confirmedAmount.contains(i)) {
                            applyThings.put(tempVal1, PriceType.FIRST);
                            confirmedAmount.add(i);
                            continue;
                        }
                        if (applyThings.containsKey(tempVal1)) continue;
                        applyThings.put(tempVal1, PriceType.NOT_FIRST);
                    }
                }
                break;
            }
        }
        return applyThings;
    }

    @Override
    public GiveResult giveSingleThing(Player player, int times, int amount) {
        TreeMap<AbstractSingleThing, BigDecimal> result = new TreeMap<AbstractSingleThing, BigDecimal>();
        GiveResult resultObject = new GiveResult(result);
        if (this.section == null || this.singlePrices.isEmpty()) {
            return resultObject;
        }
        switch (this.mode) {
            case UNKNOWN: {
                return resultObject;
            }
            case ANY: 
            case CLASSIC_ANY: {
                Collection<ObjectSinglePrice> tempVal1 = this.getTargetPrices(null, player, times, amount, true);
                for (ObjectSinglePrice tempVal5 : tempVal1) {
                    BigDecimal cost = this.getAmount(player, times, amount).get(tempVal5);
                    resultObject.addResultMapElement(tempVal5, cost);
                }
                return resultObject;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (ObjectSinglePrice tempVal2 : this.getAmount(player, times, amount).keySet()) {
                    BigDecimal cost = this.getAmount(player, times, amount).get(tempVal2);
                    resultObject.addResultMapElement(tempVal2, cost);
                }
                return resultObject;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get price-mode section in your shop config!!");
        return resultObject;
    }

    @Override
    public TakeResult takeSingleThing(Inventory inventory, Player player, int times, int amount, boolean test) {
        TreeMap<AbstractSingleThing, BigDecimal> result = new TreeMap<AbstractSingleThing, BigDecimal>();
        TakeResult resultObject = new TakeResult(result);
        if (this.section == null) {
            return resultObject;
        }
        BigDecimal cost = BigDecimal.ZERO;
        boolean needFalse = false;
        switch (this.mode) {
            case UNKNOWN: {
                return resultObject;
            }
            case ALL: 
            case CLASSIC_ALL: {
                Map<ObjectSinglePrice, BigDecimal> tempVal3 = this.getAmount(player, times, amount);
                for (ObjectSinglePrice tempVal1 : tempVal3.keySet()) {
                    if (tempVal1.empty) continue;
                    cost = tempVal3.get(tempVal1);
                    resultObject.addResultMapElement(tempVal1, cost);
                    if (test || tempVal1.playerHasEnough(inventory, player, false, cost.doubleValue())) continue;
                    needFalse = true;
                }
                if (!needFalse) {
                    resultObject.setResultBoolean();
                }
                return resultObject;
            }
            case ANY: 
            case CLASSIC_ANY: {
                Collection<ObjectSinglePrice> tempVal4 = this.getTargetPrices(inventory, player, times, amount, false);
                for (ObjectSinglePrice tempVal11 : tempVal4) {
                    if (tempVal11.empty) continue;
                    if (Objects.nonNull(this.getAmount(player, times, amount).get(tempVal11))) {
                        cost = this.getAmount(player, times, amount).get(tempVal11);
                    }
                    resultObject.addResultMapElement(tempVal11, cost);
                    if (test || !tempVal11.playerHasEnough(inventory, player, false, cost.doubleValue())) continue;
                    resultObject.setResultBoolean();
                }
                return resultObject;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get price-mode section in your shop config!!");
        return resultObject;
    }

    public Map<ObjectSinglePrice, BigDecimal> getAmount(Player player, int times, int multi) {
        TreeMap<ObjectSinglePrice, BigDecimal> priceMaps = new TreeMap<ObjectSinglePrice, BigDecimal>();
        switch (this.mode) {
            case ANY: 
            case ALL: {
                for (int i = 0; i < multi; ++i) {
                    for (ObjectSinglePrice tempVal3 : this.getAllPrices(player, times + i, 1).keySet()) {
                        if (priceMaps.containsKey(tempVal3)) {
                            priceMaps.put(tempVal3, ((BigDecimal)priceMaps.get(tempVal3)).add(tempVal3.getAmount(player, times + i, i)));
                            continue;
                        }
                        priceMaps.put(tempVal3, tempVal3.getAmount(player, times + i, i));
                    }
                }
                break;
            }
            case CLASSIC_ANY: 
            case CLASSIC_ALL: {
                for (ObjectSinglePrice tempVal3 : this.getAllPrices(player, times, multi).keySet()) {
                    if (priceMaps.containsKey(tempVal3)) {
                        priceMaps.put(tempVal3, ((BigDecimal)priceMaps.get(tempVal3)).add(tempVal3.getAmount(player, times, 0).multiply(new BigDecimal(multi))));
                        continue;
                    }
                    priceMaps.put(tempVal3, tempVal3.getAmount(player, times, 0).multiply(new BigDecimal(multi)));
                }
                break;
            }
        }
        return priceMaps;
    }

    public PriceMode getPriceMode() {
        return this.priceMode;
    }

    public static List<String> getDisplayName(Player player, int multi, Map<AbstractSingleThing, BigDecimal> result, ThingMode mode, boolean alwaysStatic) {
        TreeMap<ObjectDisplayPlaceholder, BigDecimal> tempVal1 = new TreeMap<ObjectDisplayPlaceholder, BigDecimal>();
        switch (mode) {
            case ANY: 
            case CLASSIC_ANY: {
                for (AbstractSingleThing tempVal3 : result.keySet()) {
                    if (tempVal1.containsKey(tempVal3.getDisplayPlaceholder())) {
                        tempVal1.replace(tempVal3.getDisplayPlaceholder(), ((BigDecimal)tempVal1.get(tempVal3.getDisplayPlaceholder())).add(result.get(tempVal3)));
                        continue;
                    }
                    tempVal1.put(tempVal3.getDisplayPlaceholder(), result.get(tempVal3));
                }
                break;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (AbstractSingleThing tempVal2 : result.keySet()) {
                    if (result.get(tempVal2) == null) continue;
                    if (tempVal1.containsKey(tempVal2.getDisplayPlaceholder())) {
                        tempVal1.replace(tempVal2.getDisplayPlaceholder(), ((BigDecimal)tempVal1.get(tempVal2.getDisplayPlaceholder())).add(result.get(tempVal2)));
                        continue;
                    }
                    tempVal1.put(tempVal2.getDisplayPlaceholder(), result.get(tempVal2));
                }
                break;
            }
        }
        ArrayList<String> tempVal2 = new ArrayList<String>();
        for (ObjectDisplayPlaceholder placeholder : tempVal1.keySet()) {
            tempVal2.add(TextUtil.withPAPI(placeholder.getDisplayName(multi, (BigDecimal)tempVal1.get(placeholder), alwaysStatic), player));
        }
        return tempVal2;
    }

    public static String getDisplayNameInLine(Player player, int multi, Map<AbstractSingleThing, BigDecimal> result, ThingMode mode, boolean alwaysStatic) {
        List<String> text = ObjectPrices.getDisplayName(player, multi, result, mode, alwaysStatic);
        StringBuilder tempVal2 = new StringBuilder();
        switch (mode) {
            case ANY: 
            case CLASSIC_ANY: {
                for (int i = 0; i < text.size(); ++i) {
                    if (i > 0) {
                        tempVal2.append(ConfigManager.configManager.getString("placeholder.price.split-symbol-any", new String[0]));
                    }
                    tempVal2.append(text.get(i));
                }
                break;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (int i = 0; i < text.size(); ++i) {
                    if (i > 0) {
                        tempVal2.append(ConfigManager.configManager.getString("placeholder.price.split-symbol-all", new String[0]));
                    }
                    tempVal2.append(text.get(i));
                }
                break;
            }
            default: {
                tempVal2 = new StringBuilder(ConfigManager.configManager.getString("placeholder.price.unknown-price-type", new String[0]));
            }
        }
        return tempVal2.toString().replace(";;", ConfigManager.configManager.getString("placeholder.price.replace-new-line-symbol", new String[0]));
    }
}

