/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.products;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.AbstractThings;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.products.ObjectSingleProduct;
import cn.superiormc.ultimateshop.utils.RandomUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ObjectProducts
extends AbstractThings {
    public Collection<ObjectSingleProduct> singleProducts = new TreeSet<ObjectSingleProduct>();

    public ObjectProducts() {
    }

    public ObjectProducts(ConfigurationSection section, String mode, ObjectItem item) {
        super(section, mode, item);
        this.initSingleProducts();
    }

    public void initSingleProducts() {
        for (String s : this.section.getKeys(false)) {
            if (this.section.getConfigurationSection(s) == null) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get products section in your shop config!!");
                this.singleProducts.add(new ObjectSingleProduct());
                continue;
            }
            this.singleProducts.add(new ObjectSingleProduct(s, this));
        }
    }

    @Override
    public GiveResult giveSingleThing(Player player, int times, int amount) {
        TreeMap<AbstractSingleThing, BigDecimal> result = new TreeMap<AbstractSingleThing, BigDecimal>();
        GiveResult resultObject = new GiveResult(result);
        if (this.section == null || this.singleProducts.isEmpty()) {
            return resultObject;
        }
        ArrayList<ObjectSingleProduct> tempVal6 = new ArrayList<ObjectSingleProduct>();
        switch (this.mode) {
            case UNKNOWN: {
                return resultObject;
            }
            case ANY: 
            case CLASSIC_ANY: {
                for (ObjectSingleProduct tempVal5 : this.singleProducts) {
                    if (!tempVal5.getCondition(player)) continue;
                    tempVal6.add(tempVal5);
                }
                if (tempVal6.isEmpty()) {
                    return resultObject;
                }
                ObjectSingleProduct tempVal1 = (ObjectSingleProduct)RandomUtil.getRandomElement(tempVal6);
                BigDecimal cost = this.getAmount(player, times, amount, true).get(tempVal1);
                resultObject.addResultMapElement(tempVal1, cost);
                return resultObject;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal2 : this.singleProducts) {
                    if (!tempVal2.getCondition(player)) continue;
                    BigDecimal cost = this.getAmount(player, times, amount, true).get(tempVal2);
                    resultObject.addResultMapElement(tempVal2, cost);
                }
                return resultObject;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get price-mode section in your shop config!!");
        return resultObject;
    }

    @Override
    public TakeResult takeSingleThing(Inventory inventory, Player player, int times, int amount, boolean test) {
        TreeMap<AbstractSingleThing, BigDecimal> result = new TreeMap<AbstractSingleThing, BigDecimal>();
        TakeResult resultObject = new TakeResult(result);
        if (this.section == null) {
            return resultObject;
        }
        BigDecimal cost = BigDecimal.ZERO;
        boolean needFalse = false;
        switch (this.mode) {
            case UNKNOWN: {
                return resultObject;
            }
            case ANY: 
            case CLASSIC_ANY: {
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    if (!tempVal1.getCondition(player)) continue;
                    cost = this.getAmount(player, times, amount, false).get(tempVal1);
                    resultObject.addResultMapElement(tempVal1, cost);
                    if (!test && tempVal1.playerHasEnough(inventory, player, false, cost.doubleValue())) {
                        resultObject.setResultBoolean();
                    }
                    return resultObject;
                }
                return resultObject;
            }
            case ALL: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    if (!tempVal1.getCondition(player)) continue;
                    cost = this.getAmount(player, times, amount, false).get(tempVal1);
                    resultObject.addResultMapElement(tempVal1, cost);
                    if (test || tempVal1.playerHasEnough(inventory, player, false, cost.doubleValue())) continue;
                    needFalse = true;
                }
                if (!needFalse) {
                    resultObject.setResultBoolean();
                }
                return resultObject;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get price-mode section in your shop config!!");
        return resultObject;
    }

    public Map<ObjectSingleProduct, BigDecimal> getAmount(Player player, int times, int multi, boolean buyOrSell) {
        TreeMap<ObjectSingleProduct, BigDecimal> productMaps = new TreeMap<ObjectSingleProduct, BigDecimal>();
        switch (this.mode) {
            case ANY: 
            case ALL: {
                for (int i = 0; i < multi; ++i) {
                    for (ObjectSingleProduct tempVal3 : this.singleProducts) {
                        if (productMaps.containsKey(tempVal3)) {
                            productMaps.put(tempVal3, ((BigDecimal)productMaps.get(tempVal3)).add(tempVal3.getAmount(player, i, buyOrSell)));
                            continue;
                        }
                        productMaps.put(tempVal3, tempVal3.getAmount(player, i, buyOrSell));
                    }
                }
                break;
            }
            case CLASSIC_ANY: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal3 : this.singleProducts) {
                    if (productMaps.containsKey(tempVal3)) {
                        productMaps.put(tempVal3, ((BigDecimal)productMaps.get(tempVal3)).add(tempVal3.getAmount(player, 0, buyOrSell).multiply(new BigDecimal(multi))));
                        continue;
                    }
                    productMaps.put(tempVal3, tempVal3.getAmount(player, 0, buyOrSell).multiply(new BigDecimal(multi)));
                }
                break;
            }
        }
        return productMaps;
    }

    public int getMaxAbleSellAmount(Inventory inventory, Player player, int times) {
        int maxAmount = -1;
        switch (this.mode) {
            case UNKNOWN: {
                return 0;
            }
            case ANY: 
            case CLASSIC_ANY: 
            case ALL: 
            case CLASSIC_ALL: {
                for (ObjectSingleProduct tempVal1 : this.singleProducts) {
                    double cost = this.getAmount(player, times, 1, false).get(tempVal1).doubleValue();
                    int tempVal2 = (int)(tempVal1.playerHasAmount(inventory, player) / cost);
                    if (maxAmount != -1 && tempVal2 >= maxAmount) continue;
                    maxAmount = tempVal2;
                }
                return maxAmount;
            }
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not get price-mode section in your shop config!!");
        return 0;
    }

    public ItemStack getDisplayItem(ConfigurationSection section, Player player, int times, int classic_multi) {
        for (ObjectSingleProduct tempVal1 : this.singleProducts) {
            double cost;
            ItemStack tempVal2;
            if (!tempVal1.getCondition(player) || (tempVal2 = tempVal1.getItemThing(section, player, cost = this.getAmount(player, times, classic_multi, true).get(tempVal1).doubleValue(), true).getDisplayItem()) == null) continue;
            return tempVal2;
        }
        return null;
    }
}

