/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.subobjects;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.ThingType;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectSinglePrice;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class ObjectDisplayPlaceholder
implements Comparable<ObjectDisplayPlaceholder> {
    private final AbstractSingleThing thing;
    private ConfigurationSection singleSection;

    public ObjectDisplayPlaceholder(AbstractSingleThing thing) {
        this.thing = thing;
        this.singleSection = thing.singleSection;
        if (thing instanceof ObjectSinglePrice && ((ObjectSinglePrice)thing).getCustomPrice()) {
            this.singleSection = ConfigManager.configManager.config.getConfigurationSection("prices." + this.singleSection.getString("custom-type"));
        }
    }

    public String getDisplayName(int multi, BigDecimal amount, boolean alwaysStatic) {
        return this.thing.getDisplayName(multi, amount, alwaysStatic);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.thing.type.hashCode();
        if (this.thing.type == ThingType.HOOK_ECONOMY) {
            String economyPlugin = this.singleSection.getString("economy-plugin");
            String economyType = this.singleSection.getString("economy-type");
            result = 31 * result + (economyPlugin != null ? economyPlugin.hashCode() : 0);
            result = 31 * result + (economyType != null ? economyType.hashCode() : 0);
        } else if (this.thing.type == ThingType.VANILLA_ECONOMY) {
            String economyType = this.singleSection.getString("economy-type");
            result = 31 * result + (economyType != null ? economyType.hashCode() : 0);
        } else if (this.thing.type == ThingType.HOOK_ITEM) {
            String hookPlugin = this.singleSection.getString("hook-plugin");
            String hookType = this.singleSection.getString("hook-type");
            result = 31 * result + (hookPlugin != null ? hookPlugin.hashCode() : 0);
            result = 31 * result + (hookType != null ? hookType.hashCode() : 0);
        } else if (this.thing.type == ThingType.VANILLA_ITEM || this.thing.type == ThingType.MATCH_ITEM) {
            result = 31 * result + this.convertConfigurationSection(this.singleSection).hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectDisplayPlaceholder otherPrice = (ObjectDisplayPlaceholder)obj;
        if (this.singleSection.getString("placeholder") != null && otherPrice.singleSection.getString("placeholder") != null) {
            return this.singleSection.getString("placeholder").equals(otherPrice.singleSection.getString("placeholder"));
        }
        if (this.thing.type == ThingType.FREE || this.thing.type == ThingType.UNKNOWN) {
            return true;
        }
        if (this.thing.type == ThingType.HOOK_ECONOMY) {
            if (this.singleSection.getString("economy-plugin") == null) {
                return true;
            }
            if (this.singleSection.getString("economy-type") == null) {
                return this.singleSection.getString("economy-plugin").equals(otherPrice.singleSection.getString("economy-plugin"));
            }
            return this.singleSection.getString("economy-plugin").equals(otherPrice.singleSection.getString("economy-plugin")) && this.singleSection.getString("economy-type").equals(otherPrice.singleSection.getString("economy-type"));
        }
        if (this.thing.type == ThingType.VANILLA_ECONOMY) {
            if (this.singleSection.getString("economy-type") == null) {
                return true;
            }
            return this.singleSection.getString("economy-type").equals(otherPrice.singleSection.getString("economy-type"));
        }
        if (this.thing.type == ThingType.HOOK_ITEM) {
            if (this.singleSection.getString("hook-plugin") == null) {
                return true;
            }
            if (this.singleSection.getString("hook-item") == null) {
                return this.singleSection.getString("hook-plugin").equals(otherPrice.singleSection.getString("hook-plugin"));
            }
            return this.singleSection.getString("hook-plugin").equals(otherPrice.singleSection.getString("hook-plugin")) && this.singleSection.getString("hook-type").equals(otherPrice.singleSection.getString("hook-type"));
        }
        if (this.thing.type == ThingType.VANILLA_ITEM || this.thing.type == ThingType.MATCH_ITEM) {
            return this.areConfigurationSectionsEqual(this.singleSection, otherPrice.singleSection);
        }
        return super.equals(obj);
    }

    private boolean areConfigurationSectionsEqual(ConfigurationSection section1, ConfigurationSection section2) {
        if (section1 == section2) {
            return true;
        }
        if (section1 == null || section2 == null) {
            return false;
        }
        if (!section1.getKeys(true).equals(section2.getKeys(true))) {
            return false;
        }
        List<String> notCheckKey = List.of("apply", "start-apply", "end-apply", "placeholder", "conditions", "amount");
        for (String key : section1.getKeys(true)) {
            if (notCheckKey.contains(key) || section1.get(key).equals(section2.get(key))) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> convertConfigurationSection(ConfigurationSection section) {
        Map values = section.getValues(false);
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> notCheckKey = List.of("apply", "start-apply", "end-apply", "placeholder", "conditions", "amount");
        for (String key : values.keySet()) {
            Object value;
            if (notCheckKey.contains(key) || (value = values.get(key)) == null) continue;
            result.put(key, value.toString());
        }
        return result;
    }

    public AbstractSingleThing getThing() {
        return this.thing;
    }

    @Override
    public int compareTo(@NotNull ObjectDisplayPlaceholder o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.thing.compareTo(o.getThing());
    }
}

