/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.subobjects;

import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.caches.ObjectRandomPlaceholderCache;
import cn.superiormc.ultimateshop.utils.RandomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectRandomPlaceholder {
    private final String id;
    private final ConfigurationSection section;
    private final List<String> elements = new ArrayList<String>();
    private final Collection<ObjectRandomPlaceholder> notSameAs = new ArrayList<ObjectRandomPlaceholder>();

    public ObjectRandomPlaceholder(String id, ConfigurationSection section) {
        this.id = id;
        this.section = section;
        this.initElements(true);
    }

    public void initElements(boolean firstLoad) {
        this.elements.addAll(this.section.getStringList("elements"));
        for (int i = 0; i < this.elements.size(); ++i) {
            ObjectRandomPlaceholder tempVal2 = ConfigManager.configManager.getRandomPlaceholder(this.elements.get(i));
            if (tempVal2 == null || tempVal2.equals(this) || tempVal2.getElements().isEmpty()) continue;
            this.elements.remove(this.elements.get(i));
            this.elements.addAll(tempVal2.getElements());
        }
        if (!firstLoad) {
            for (String removeElement : this.section.getStringList("not-same-as")) {
                ObjectRandomPlaceholder tempVal2 = ConfigManager.configManager.getRandomPlaceholder(removeElement);
                if (tempVal2 == null || tempVal2.equals(this)) continue;
                this.elements.remove(tempVal2.getNowValue());
                this.notSameAs.add(tempVal2);
            }
        }
    }

    public Collection<ObjectRandomPlaceholder> getNotSameAs() {
        return this.notSameAs;
    }

    public String getID() {
        return this.id;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getNewValue() {
        if (this.elements.isEmpty()) {
            return "ERROR: Value Empty";
        }
        String[] element = RandomUtil.getRandomElement(this.elements).split("~");
        if (element.length == 1) {
            return element[0];
        }
        int min = Integer.parseInt(element[0]);
        int max = Integer.parseInt(element[1]);
        Random random = new Random();
        return String.valueOf(random.nextInt(max - min + 1) + min);
    }

    public ConfigurationSection getConfig() {
        return this.section;
    }

    public String getMode() {
        String tempVal1 = this.section.getString("reset-mode");
        if (tempVal1 == null) {
            return "NEVER";
        }
        return tempVal1.toUpperCase();
    }

    public String getNowValue() {
        ObjectRandomPlaceholderCache tempVal1 = CacheManager.cacheManager.serverCache.getRandomPlaceholderCache().get(this);
        if (tempVal1 == null) {
            CacheManager.cacheManager.serverCache.addRandomPlaceholderCache(this);
            tempVal1 = CacheManager.cacheManager.serverCache.getRandomPlaceholderCache().get(this);
        }
        return tempVal1.getNowValue(false, false);
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectRandomPlaceholder) {
            return ((ObjectRandomPlaceholder)object).getID().equals(this.getID());
        }
        return false;
    }

    public static String getNowValue(String id) {
        return "ERROR: Free Version";
    }

    public static String getRefreshDoneTime(String id) {
        return "ERROR: Free Version";
    }
}

