/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.menus;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.menus.MenuType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ObjectMenu {
    public MenuType type;
    public static Map<String, ObjectMenu> commonMenus = new HashMap<String, ObjectMenu>();
    public static Map<ObjectShop, ObjectMenu> shopMenus = new HashMap<ObjectShop, ObjectMenu>();
    public static List<String> shopMenuNames = new ArrayList<String>();
    public static List<String> buyMoreMenuNames = new ArrayList<String>();
    public String fileName;
    private ObjectShop shop = null;
    private ObjectCondition condition;
    private ObjectAction openAction;
    private ObjectAction closeAction;
    public Configuration menuConfigs;
    public Map<Integer, AbstractButton> menuItems = new TreeMap<Integer, AbstractButton>();
    public Map<String, AbstractButton> buttonItems = new HashMap<String, AbstractButton>();

    public ObjectMenu(String fileName, ObjectShop shop) {
        this.fileName = fileName;
        this.shop = shop;
        this.type = MenuType.Shop;
        this.initMenu();
        this.initShopItems();
        this.initButtonItems();
    }

    public ObjectMenu(String fileName, ObjectItem item) {
        this.fileName = fileName;
        this.shop = item.getShopObject();
        this.type = MenuType.More;
        this.initMenu();
        this.initButtonItems();
    }

    public ObjectMenu(String fileName) {
        this.fileName = fileName;
        this.type = MenuType.Common;
        this.initMenu();
        this.initButtonItems();
    }

    public MenuType getType() {
        return this.type;
    }

    public void initMenu() {
        if (this.type == MenuType.Common) {
            commonMenus.put(this.fileName, this);
        } else {
            shopMenus.put(this.shop, this);
            shopMenuNames.add(this.fileName);
        }
        File file = new File(UltimateShop.instance.getDataFolder() + "/menus/" + this.fileName + ".yml");
        if (!file.exists()) {
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: We can not found your menu file: " + this.fileName + ".yml!");
        } else {
            if (this.type == MenuType.Common) {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7fLoaded menu: " + this.fileName + ".yml!");
            }
            this.menuConfigs = YamlConfiguration.loadConfiguration((File)file);
        }
        if (this.menuConfigs == null) {
            this.condition = new ObjectCondition();
            this.openAction = new ObjectAction();
            this.closeAction = new ObjectAction();
        } else {
            this.condition = new ObjectCondition(this.menuConfigs.getStringList("conditions"));
            this.openAction = new ObjectAction(this.menuConfigs.getStringList("open-actions"));
            this.closeAction = new ObjectAction(this.menuConfigs.getStringList("close-actions"));
        }
    }

    public void initShopItems() {
        int i = 0;
        if (this.menuConfigs == null) {
            return;
        }
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            for (int c = 0; c < singleLine.length(); ++c) {
                char itemChar = singleLine.charAt(c);
                int slot = i++;
                if (this.shop.getProduct(String.valueOf(itemChar)) == null) {
                    if (this.shop.getButton(String.valueOf(itemChar)) == null) continue;
                    this.menuItems.put(slot, this.shop.getButton(String.valueOf(itemChar)));
                    continue;
                }
                this.menuItems.put(slot, this.shop.getProduct(String.valueOf(itemChar)));
            }
        }
    }

    public void initButtonItems() {
        if (this.menuConfigs == null) {
            return;
        }
        ConfigurationSection tempVal1 = this.menuConfigs.getConfigurationSection("buttons");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            if (this.shop == null) {
                this.buttonItems.put(button, new ObjectButton(tempVal1.getConfigurationSection(button)));
                continue;
            }
            this.buttonItems.put(button, new ObjectButton(tempVal1.getConfigurationSection(button), this.shop));
        }
        int i = 0;
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            for (int c = 0; c < singleLine.length(); ++c) {
                char itemChar = singleLine.charAt(c);
                int slot = i++;
                if (this.buttonItems.get(String.valueOf(itemChar)) == null) continue;
                this.menuItems.put(slot, this.buttonItems.get(String.valueOf(itemChar)));
            }
        }
    }

    public String getString(String path, String defaultValue) {
        if (defaultValue == null) {
            return this.menuConfigs.getString(path);
        }
        return this.menuConfigs.getString(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.menuConfigs.getInt(path, defaultValue);
    }

    public Map<Integer, AbstractButton> getMenu() {
        return this.menuItems;
    }

    public ObjectCondition getCondition() {
        return this.condition;
    }

    public void doOpenAction(Player player) {
        if (this.openAction != null) {
            this.openAction.doAction(player, 1, 1, false);
        }
    }

    public void doCloseAction(Player player) {
        if (this.closeAction != null) {
            this.closeAction.doAction(player, 1, 1, false);
        }
    }

    public String getName() {
        return this.fileName;
    }
}

