/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.menus;

import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreBuyButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreDisplayButton;
import cn.superiormc.ultimateshop.objects.menus.MenuType;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectMoreMenu
extends ObjectMenu {
    public static Map<ObjectItem, ObjectMoreMenu> moreMenus = new HashMap<ObjectItem, ObjectMoreMenu>();
    private ObjectItem item;
    private int displayItemSlot = -1;
    private ConfigurationSection section;

    public ObjectMoreMenu(ConfigurationSection section, ObjectItem item) {
        super(section.getString("menu", "buy-more"), item);
        this.item = item;
        this.type = MenuType.More;
        this.section = section;
        moreMenus.put(item, this);
        ObjectMenu.buyMoreMenuNames.add(section.getString("menu", "buy-more"));
        this.initDisplayItem();
        this.initConfirmItem();
        this.initSelectAmountItem();
    }

    private void initDisplayItem() {
        if (this.menuConfigs == null) {
            return;
        }
        String displayItem = this.menuConfigs.getString("display-item");
        if (displayItem == null) {
            return;
        }
        int i = 0;
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            for (int c = 0; c < singleLine.length(); ++c) {
                char itemChar = singleLine.charAt(c);
                int slot = i++;
                if (!displayItem.equals(String.valueOf(itemChar))) continue;
                this.displayItemSlot = slot;
                this.menuItems.put(slot, new ObjectMoreDisplayButton(this.menuConfigs.getConfigurationSection("display-item"), this.item));
            }
        }
    }

    private void initConfirmItem() {
        if (this.menuConfigs == null) {
            return;
        }
        ConfigurationSection tempVal1 = this.menuConfigs.getConfigurationSection("confirm-items");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            this.buttonItems.put(button, new ObjectMoreBuyButton(tempVal1.getConfigurationSection(button), this.item));
        }
        int i = 0;
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            for (int c = 0; c < singleLine.length(); ++c) {
                char itemChar = singleLine.charAt(c);
                int slot = i++;
                if (this.buttonItems.get(String.valueOf(itemChar)) == null) continue;
                this.menuItems.put(slot, (AbstractButton)this.buttonItems.get(String.valueOf(itemChar)));
            }
        }
    }

    private void initSelectAmountItem() {
        if (this.menuConfigs == null) {
            return;
        }
        ConfigurationSection tempVal1 = this.menuConfigs.getConfigurationSection("amount-items");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            this.buttonItems.put(button, new ObjectMoreButton(tempVal1.getConfigurationSection(button)));
        }
        int i = 0;
        for (String singleLine : this.menuConfigs.getStringList("layout")) {
            for (int c = 0; c < singleLine.length(); ++c) {
                char itemChar = singleLine.charAt(c);
                int slot = i++;
                if (this.buttonItems.get(String.valueOf(itemChar)) == null) continue;
                this.menuItems.put(slot, (AbstractButton)this.buttonItems.get(String.valueOf(itemChar)));
            }
        }
    }

    public int getDisplayItemSlot() {
        return this.displayItemSlot;
    }

    public ConfigurationSection getSection() {
        return this.section;
    }
}

