/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.utils.TextUtil;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.geysermc.floodgate.api.FloodgateApi;
import org.json.JSONObject;

public class CommonUtil {
    public static boolean checkPluginLoad(String pluginName) {
        if (pluginName == null) {
            return false;
        }
        return UltimateShop.instance.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public static boolean checkPermission(Player player, String permission) {
        if (CommonUtil.checkPluginLoad("LuckPerms")) {
            return LuckPermsProvider.get().getPlayerAdapter(Player.class).getPermissionData((Object)player).checkPermission(permission).asBoolean();
        }
        return player.hasPermission(permission);
    }

    public static boolean getMajorVersion(int version) {
        return UltimateShop.majorVersion >= version;
    }

    public static boolean getMinorVersion(int majorVersion, int minorVersion) {
        return UltimateShop.majorVersion > majorVersion || UltimateShop.majorVersion == majorVersion && UltimateShop.miniorVersion >= minorVersion;
    }

    public static void dispatchCommand(String command) {
        if (UltimateShop.isFolia) {
            Bukkit.getGlobalRegionScheduler().run((Plugin)UltimateShop.instance, task -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
            return;
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    public static void dispatchCommand(Player player, String command) {
        if (UltimateShop.isFolia) {
            player.getScheduler().run((Plugin)UltimateShop.instance, task -> Bukkit.dispatchCommand((CommandSender)player, (String)command), () -> {});
            return;
        }
        Bukkit.dispatchCommand((CommandSender)player, (String)command);
    }

    public static void dispatchOpCommand(Player player, String command) {
        if (UltimateShop.isFolia) {
            player.getScheduler().run((Plugin)UltimateShop.instance, task -> {
                boolean playerIsOp = player.isOp();
                try {
                    player.setOp(true);
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                }
                finally {
                    player.setOp(playerIsOp);
                }
            }, () -> {});
            return;
        }
        boolean playerIsOp = player.isOp();
        try {
            player.setOp(true);
            Bukkit.dispatchCommand((CommandSender)player, (String)command);
        }
        finally {
            player.setOp(playerIsOp);
        }
    }

    public static void summonMythicMobs(Location location, String mobID, int level) {
        block3: {
            try {
                MythicMob mob = MythicBukkit.inst().getMobManager().getMythicMob(mobID).orElse(null);
                if (mob != null) {
                    mob.spawn(io.lumine.mythic.bukkit.BukkitAdapter.adapt((Location)location), (double)level);
                }
            }
            catch (NoClassDefFoundError ep) {
                io.lumine.xikage.mythicmobs.mobs.MythicMob mob = MythicMobs.inst().getMobManager().getMythicMob(mobID);
                if (mob == null) break block3;
                mob.spawn(BukkitAdapter.adapt((Location)location), (double)level);
            }
        }
    }

    public static String modifyString(String text, String ... args) {
        for (int i = 0; i < args.length; i += 2) {
            String var1 = "{" + args[i] + "}";
            String var2 = "{" + args[i] + "}";
            text = args[i + 1] == null ? text.replace(var1, "").replace(var2, "") : text.replace(var1, args[i + 1]).replace(var2, args[i + 1]);
        }
        return text;
    }

    public static List<String> modifyList(Player player, List<String> config, String ... args) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String s : config) {
            for (int i = 0; i < args.length; i += 2) {
                String var = "{" + args[i] + "}";
                s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
            }
            String[] tempVal1 = s.split(";;");
            if (tempVal1.length > 1) {
                for (String string : tempVal1) {
                    resultList.add(TextUtil.parse(string, player));
                }
                continue;
            }
            resultList.add(TextUtil.parse(s, player));
        }
        return resultList;
    }

    public static LocalDateTime stringToTime(String time) {
        if (time.equals("null")) {
            return null;
        }
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String timeToString(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String timeToString(LocalDateTime time, String format) {
        if (time == null) {
            return null;
        }
        return time.format(DateTimeFormatter.ofPattern(format));
    }

    public static void mkDir(File dir) {
        if (!dir.exists()) {
            File parentFile = dir.getParentFile();
            if (parentFile == null) {
                return;
            }
            String parentPath = parentFile.getPath();
            CommonUtil.mkDir(new File(parentPath));
            dir.mkdir();
        }
    }

    public static boolean getClass(String className) {
        if (!ConfigManager.configManager.getBoolean("check-class.enabled")) {
            return ConfigManager.configManager.config.getStringList("check-class.classes").contains(className);
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isBedrockPlayer(Player player) {
        if (!UltimateShop.useGeyser) {
            return false;
        }
        if (ConfigManager.configManager.getString("menu.bedrock.check-method", "FLOODGATE").equalsIgnoreCase("FLOODGATE")) {
            return FloodgateApi.getInstance().getPlayer(player.getUniqueId()) != null;
        }
        return player.getUniqueId().toString().startsWith("00000000-0000-0000-000");
    }

    public static NamespacedKey parseNamespacedKey(String key) {
        String[] keySplit = key.split(":");
        if (keySplit.length == 1) {
            return NamespacedKey.minecraft((String)key.toLowerCase());
        }
        return NamespacedKey.fromString((String)key);
    }

    public static Color parseColor(String color) {
        String[] keySplit = color.replace(" ", "").split(",");
        if (keySplit.length == 3) {
            return Color.fromRGB((int)Integer.parseInt(keySplit[0]), (int)Integer.parseInt(keySplit[1]), (int)Integer.parseInt(keySplit[2]));
        }
        return Color.fromRGB((int)Integer.parseInt(color));
    }

    public static void giveOrDrop(Player player, ItemStack ... item) {
        HashMap result = player.getInventory().addItem(item);
        if (!result.isEmpty()) {
            Iterator iterator = result.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                player.getWorld().dropItem(player.getLocation(), (ItemStack)result.get(id));
            }
        }
    }

    public static JSONObject fetchJson(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            JSONObject jSONObject = new JSONObject(response.toString());
            return jSONObject;
        }
    }

    public static void logFile(String filePath, String textToAppend) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(UltimateShop.instance.getDataFolder() + "/" + filePath, true));){
            writer.write(textToAppend);
            writer.newLine();
        }
        catch (IOException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[UltimateShop] \u00a7cError: Can not write log file: " + filePath);
        }
    }
}

