/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LocateManager;
import cn.superiormc.ultimateshop.methods.Items.DebuildItem;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.inventory.ItemStack;
import pers.neige.neigeitems.utils.ItemUtils;

public class ItemUtil {
    public static String getItemName(ItemStack displayItem) {
        if (displayItem == null || displayItem.getItemMeta() == null) {
            return "";
        }
        if (displayItem.getItemMeta().hasDisplayName()) {
            return displayItem.getItemMeta().getDisplayName();
        }
        if (LocateManager.enableThis() && LocateManager.locateManager != null) {
            return LocateManager.locateManager.getLocateName(displayItem);
        }
        if (CommonUtil.checkPluginLoad("NeigeItems")) {
            return ItemUtils.getItemName((ItemStack)displayItem);
        }
        return ItemUtil.getItemNameWithoutVanilla(displayItem);
    }

    public static String getItemNameWithoutVanilla(ItemStack displayItem) {
        if (displayItem == null || displayItem.getItemMeta() == null) {
            return "";
        }
        if (displayItem.getItemMeta().hasDisplayName()) {
            return displayItem.getItemMeta().getDisplayName();
        }
        StringBuilder result = new StringBuilder();
        for (String word : displayItem.getType().name().toLowerCase().split("_")) {
            if (word.isEmpty()) continue;
            char firstChar = Character.toUpperCase(word.charAt(0));
            String restOfWord = word.substring(1);
            result.append(firstChar).append(restOfWord).append(" ");
        }
        return result.toString();
    }

    public static boolean isSameItem(ItemStack item1, ItemStack item2) {
        if (ConfigManager.configManager.getStringOrDefault("sell-mode", "sell.sell-method", "Bukkit").equals("Bukkit")) {
            return item1.equals((Object)item2);
        }
        Map item1Result = DebuildItem.debuildItem(item1, (ConfigurationSection)new MemoryConfiguration()).getValues(true);
        Map item2Result = DebuildItem.debuildItem(item2, (ConfigurationSection)new MemoryConfiguration()).getValues(true);
        for (String key : item1Result.keySet()) {
            if (ConfigManager.configManager.getStringList("sell.ignore-item-format-key").contains(key) || item2Result.get(key) != null && item2Result.get(key).equals(item1Result.get(key))) continue;
            return false;
        }
        return true;
    }
}

