/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.config;

import fr.mrmicky.worldeditselectionvisualizer.WorldEditSelectionVisualizer;
import fr.mrmicky.worldeditselectionvisualizer.config.GlobalSelectionConfig;
import fr.mrmicky.worldeditselectionvisualizer.config.SelectionConfig;
import fr.mrmicky.worldeditselectionvisualizer.display.Particle;
import fr.mrmicky.worldeditselectionvisualizer.particles.ParticleData;
import fr.mrmicky.worldeditselectionvisualizer.particles.ParticleType;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionType;
import java.util.Locale;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationManager {
    private final WorldEditSelectionVisualizer plugin;

    public ConfigurationManager(WorldEditSelectionVisualizer plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public GlobalSelectionConfig loadGlobalSelectionConfig(SelectionType type) {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("visualization." + type.getName());
        int fadeDelay = section.getInt("fade-delay");
        int max = section.getInt("max-selection-size");
        SelectionConfig primary = this.loadSelectionConfig(section.getConfigurationSection("primary"));
        SelectionConfig secondary = this.loadSelectionConfig(section.getConfigurationSection("secondary"));
        SelectionConfig origin = this.loadSelectionConfig(section.getConfigurationSection("origin"));
        return new GlobalSelectionConfig(fadeDelay, max, primary, secondary, origin);
    }

    @NotNull
    private SelectionConfig loadSelectionConfig(ConfigurationSection config) {
        return new SelectionConfig(config, this::loadParticle);
    }

    @NotNull
    public Particle loadParticle(ConfigurationSection config) {
        if (config == null) {
            return Particle.FALLBACK;
        }
        String rawType = config.getString("type");
        if (rawType == null) {
            return Particle.FALLBACK;
        }
        try {
            ParticleType type = ParticleType.of(rawType);
            String data = config.getString("data");
            return new Particle(type, this.loadParticleData(type.getDataType(), data));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid or unsupported particle type in the config: " + rawType);
            return Particle.FALLBACK;
        }
    }

    @Nullable
    private ParticleData loadParticleData(Class<?> dataClass, String name) {
        if (dataClass == ParticleData.DustOptions.class) {
            if (name == null || name.isEmpty()) {
                return ParticleData.createDustOptions(Color.RED, 1.0f);
            }
            try {
                String[] split = name.split(",");
                if (split.length == 3) {
                    int r = Integer.parseInt(split[0]);
                    int g = Integer.parseInt(split[1]);
                    int b = Integer.parseInt(split[2]);
                    return ParticleData.createDustOptions(Color.fromRGB((int)r, (int)g, (int)b), 1.0f);
                }
                Color color = (Color)Color.class.getField(name.toUpperCase(Locale.ROOT)).get(null);
                return ParticleData.createDustOptions(color, 1.0f);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                this.plugin.getLogger().warning("Invalid particle color in the config: " + name);
                return ParticleData.createDustOptions(Color.RED, 1.0f);
            }
        }
        if (dataClass == ItemStack.class) {
            return ParticleData.of(new ItemStack(this.getMaterial(name, false)));
        }
        if (dataClass == ParticleData.BlockData.class) {
            return ParticleData.createBlockData(this.getMaterial(name, true));
        }
        if (dataClass == Void.class) {
            return null;
        }
        throw new IllegalArgumentException("Invalid particle data: " + dataClass.getName());
    }

    @NotNull
    private Material getMaterial(String type, boolean needBlock) {
        Material material = Material.matchMaterial((String)type);
        if (material == null) {
            this.plugin.getLogger().warning("Invalid material for particle in the config: " + type);
            return Material.STONE;
        }
        if (needBlock && !material.isBlock()) {
            this.plugin.getLogger().warning("The material for particle in the config must be a block: " + type);
            return Material.STONE;
        }
        return material;
    }
}

