/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.particles;

import fr.mrmicky.worldeditselectionvisualizer.particles.ParticleTypes;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public interface ParticleData {
    public static ParticleData of(ItemStack item) {
        return new AbstractParticleData(Objects.requireNonNull(item, "item"));
    }

    public static BlockData createBlockData(Material material) {
        return ParticleData.createBlockData(material, (byte)0);
    }

    public static BlockData createBlockData(Material material, byte legacyData) {
        Objects.requireNonNull(material, "material");
        if (!ParticleTypes.MODERN) {
            return new BlockData(new MaterialData(material, legacyData));
        }
        return new BlockData(Bukkit.createBlockData((Material)material));
    }

    public static DustOptions createDustOptions(Color color, float size) {
        Objects.requireNonNull(color, "color");
        if (ParticleTypes.DUST_OPTIONS_CLASS == null) {
            return new DustOptions(color);
        }
        return new DustOptions(new Particle.DustOptions(color, size));
    }

    public static DustTransition createDustTransition(Color fromColor, Color toColor, float size) {
        Objects.requireNonNull(fromColor, "fromColor");
        Objects.requireNonNull(toColor, "toColor");
        if (ParticleTypes.DUST_TRANSITION_CLASS == null) {
            return DustTransition.EMPTY;
        }
        return new DustTransition(new Particle.DustTransition(fromColor, toColor, size));
    }

    public static class AbstractParticleData
    implements ParticleData {
        final Object data;

        private AbstractParticleData(Object data) {
            this.data = data;
        }
    }

    public static class BlockData
    extends AbstractParticleData {
        private BlockData(Object data) {
            super(data);
        }
    }

    public static class DustOptions
    extends AbstractParticleData {
        private DustOptions(Object data) {
            super(data);
        }
    }

    public static class DustTransition
    extends DustOptions {
        private static final DustTransition EMPTY = new DustTransition(null);

        private DustTransition(Object data) {
            super(data);
        }
    }
}

