/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.particles;

import fr.mrmicky.worldeditselectionvisualizer.particles.FastReflection;
import fr.mrmicky.worldeditselectionvisualizer.particles.LegacyParticleType;
import fr.mrmicky.worldeditselectionvisualizer.particles.ParticleData;
import fr.mrmicky.worldeditselectionvisualizer.particles.ParticleType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;

final class ParticleTypes {
    static final Class<?> BLOCK_DATA_CLASS = FastReflection.optionalClass("org.bukkit.block.data.BlockData").orElse(null);
    static final Class<?> DUST_OPTIONS_CLASS = FastReflection.optionalClass("org.bukkit.Particle$DustOptions").orElse(null);
    static final Class<?> DUST_TRANSITION_CLASS = FastReflection.optionalClass("org.bukkit.Particle$DustTransition").orElse(null);
    static final Map<Class<?>, Class<?>> DATA_ADAPTERS = new HashMap();
    static final boolean LEGACY = !FastReflection.optionalClass("org.bukkit.Particle").isPresent();
    static final boolean MODERN = BLOCK_DATA_CLASS != null && Particle.FALLING_DUST.getDataType() == BLOCK_DATA_CLASS;
    static final ParticleData.DustOptions DEFAULT_DUST_OPTIONS = ParticleData.createDustOptions(Color.RED, 1.0f);

    private ParticleTypes() {
        throw new UnsupportedOperationException();
    }

    static ParticleType of(String name) {
        Objects.requireNonNull(name, "name");
        try {
            if (LEGACY) {
                return LegacyParticleType.of(name.toUpperCase(Locale.ROOT));
            }
            return new DefaultParticleType(Particle.valueOf((String)name.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid or unsupported particle type: " + name);
        }
    }

    static double color(double color) {
        return color / 255.0;
    }

    static {
        DATA_ADAPTERS.put(MaterialData.class, ParticleData.BlockData.class);
        DATA_ADAPTERS.put(Color.class, ParticleData.DustOptions.class);
        if (BLOCK_DATA_CLASS != null) {
            DATA_ADAPTERS.put(BLOCK_DATA_CLASS, ParticleData.BlockData.class);
        }
        if (DUST_OPTIONS_CLASS != null) {
            DATA_ADAPTERS.put(DUST_OPTIONS_CLASS, ParticleData.DustOptions.class);
        }
        if (DUST_TRANSITION_CLASS != null) {
            DATA_ADAPTERS.put(DUST_TRANSITION_CLASS, ParticleData.DustTransition.class);
        }
    }

    static final class DefaultParticleType
    implements ParticleType {
        private static final Particle OLD_REDSTONE = LEGACY || MODERN ? null : Particle.valueOf((String)"REDSTONE");
        private static final boolean WORLD_HAS_FORCE = DefaultParticleType.hasForceArgument(World.class);
        private static final boolean PLAYER_HAS_FORCE = DefaultParticleType.hasForceArgument(Player.class);
        private final Particle particle;

        public DefaultParticleType(Particle particle) {
            this.particle = Objects.requireNonNull(particle, "particle");
        }

        @Override
        public String getName() {
            return this.particle.name();
        }

        @Override
        public Class<?> getRawDataType() {
            Class type = this.particle.getDataType();
            if (type == Void.class && this.particle == OLD_REDSTONE) {
                return Color.class;
            }
            return type;
        }

        @Override
        public <T> void spawn(World world, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
            Object newData = this.mapData(data);
            if (newData instanceof Color) {
                Color color = (Color)newData;
                count = 0;
                offsetX = ParticleTypes.color(color.getRed());
                offsetY = ParticleTypes.color(color.getGreen());
                offsetZ = ParticleTypes.color(color.getBlue());
                extra = 1.0;
                newData = null;
            }
            if (WORLD_HAS_FORCE) {
                world.spawnParticle(this.particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, newData, force);
            } else {
                world.spawnParticle(this.particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, newData);
            }
        }

        @Override
        public <T> void spawn(Player player, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
            Object newData = this.mapData(data);
            if (newData instanceof Color) {
                Color color = (Color)newData;
                count = 0;
                offsetX = ParticleTypes.color(color.getRed());
                offsetY = ParticleTypes.color(color.getGreen());
                offsetZ = ParticleTypes.color(color.getBlue());
                extra = 1.0;
                newData = null;
            }
            if (PLAYER_HAS_FORCE) {
                player.spawnParticle(this.particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, newData, force);
            } else {
                player.spawnParticle(this.particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, newData);
            }
        }

        private Object mapData(Object data) {
            Class dataType = this.particle.getDataType();
            if (data instanceof ParticleData.AbstractParticleData) {
                data = ((ParticleData.AbstractParticleData)data).data;
            }
            if (dataType == Void.class) {
                if (data instanceof Color && this.particle == OLD_REDSTONE) {
                    return data;
                }
                return null;
            }
            if (dataType == DUST_OPTIONS_CLASS) {
                if (data instanceof Color) {
                    return new Particle.DustOptions((Color)data, 1.0f);
                }
                if (data == null) {
                    return ParticleTypes.DEFAULT_DUST_OPTIONS.data;
                }
            }
            if (dataType == BLOCK_DATA_CLASS && data instanceof MaterialData) {
                return Bukkit.createBlockData((Material)((MaterialData)data).getItemType());
            }
            return data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultParticleType)) {
                return false;
            }
            DefaultParticleType particleType = (DefaultParticleType)o;
            return this.particle == particleType.particle;
        }

        public int hashCode() {
            return this.particle.hashCode();
        }

        public String toString() {
            return "DefaultParticleType{particle=" + this.particle + '}';
        }

        private static boolean hasForceArgument(Class<?> type) {
            if (LEGACY) {
                return false;
            }
            try {
                type.getMethod("spawnParticle", Particle.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Object.class, Boolean.TYPE);
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
    }
}

