/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.selection;

import fr.mrmicky.worldeditselectionvisualizer.selection.PlayerSelection;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionType;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerVisualizerData {
    private final Map<SelectionType, PlayerSelection> enabledVisualizations = new EnumMap<SelectionType, PlayerSelection>(SelectionType.class);
    @NotNull
    private final Player player;
    @Nullable
    private Location clipboardLockLocation;
    private boolean holdingSelectionItem = true;

    public PlayerVisualizerData(@NotNull Player player) {
        this.player = Objects.requireNonNull(player, "player");
    }

    @NotNull
    public Optional<PlayerSelection> getSelection(SelectionType type) {
        return Optional.ofNullable(this.enabledVisualizations.get((Object)type));
    }

    @NotNull
    public Collection<PlayerSelection> getEnabledVisualizations() {
        return this.enabledVisualizations.values();
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public boolean isHoldingSelectionItem() {
        return this.holdingSelectionItem;
    }

    public void setHoldingSelectionItem(boolean holdingSelectionItem) {
        this.holdingSelectionItem = holdingSelectionItem;
    }

    public boolean isSelectionVisible(SelectionType type) {
        return this.enabledVisualizations.containsKey((Object)type);
    }

    public void toggleSelectionVisibility(SelectionType type, boolean enable) {
        if (!enable) {
            this.enabledVisualizations.remove((Object)type);
            return;
        }
        this.enabledVisualizations.computeIfAbsent(type, PlayerSelection::new);
    }

    @NotNull
    public Location getClipboardLocation() {
        if (this.clipboardLockLocation == null) {
            return this.player.getLocation();
        }
        return this.clipboardLockLocation;
    }

    @Nullable
    public Location getClipboardLockLocation() {
        return this.clipboardLockLocation;
    }

    public void setClipboardLockLocation(@Nullable Location location) {
        this.clipboardLockLocation = location;
    }
}

