/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.utils;

import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class ChatUtils {
    private static final boolean HEX_COLORS;

    private ChatUtils() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static String color(@NotNull String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)ChatUtils.colorHex(s));
    }

    @VisibleForTesting
    @NotNull
    public static String colorHex(@NotNull String s) {
        if (!HEX_COLORS) {
            return s;
        }
        for (int i = 0; i < s.length() - 7; ++i) {
            if (s.charAt(i) != '&' || s.charAt(i + 1) != '#') continue;
            String color = net.md_5.bungee.api.ChatColor.of((String)s.substring(i + 1, i + 8)).toString();
            s = s.substring(0, i) + color + s.substring(i + 8);
            i += color.length() - 1;
        }
        return s;
    }

    static {
        boolean hasHexColors = true;
        try {
            Class.forName("net.md_5.bungee.api.ChatColor");
            net.md_5.bungee.api.ChatColor.class.getMethod("of", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            hasHexColors = false;
        }
        HEX_COLORS = hasHexColors;
    }
}

