/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud;

import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import java.util.Objects;
import java.util.logging.Logger;
import one.oth3r.directionhud.EventManager;
import one.oth3r.directionhud.PacketHelper;
import one.oth3r.directionhud.commands.DHUDCommand;
import one.oth3r.directionhud.commands.DestinationCommand;
import one.oth3r.directionhud.commands.HUDCommand;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.Events;
import one.oth3r.directionhud.common.LoopManager;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.PluginData;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class DirectionHUD
extends JavaPlugin
implements PluginMessageListener {
    public static Logger LOGGER;
    private static final PluginData pluginData;

    public static PluginData getData() {
        return pluginData;
    }

    public void onEnable() {
        DirectionHUD.getData().setPlugin((Plugin)this);
        DirectionHUD.getData().setDataDirectory(this.getDataFolder().getPath() + "/");
        DirectionHUD.getData().setConfigDirectory(this.getDataFolder().getPath() + "/");
        DirectionHUD.getData().setVersion(Objects.requireNonNull(Bukkit.getServer().getPluginManager().getPlugin("DirectionHUD")).getPluginMeta().getVersion());
        LOGGER = this.getLogger();
        Events.init();
        Events.serverStart();
        Objects.requireNonNull(this.getCommand("destination")).setExecutor((CommandExecutor)new DestinationCommand());
        Objects.requireNonNull(this.getCommand("destination")).setTabCompleter((TabCompleter)new DestinationCommand());
        Objects.requireNonNull(this.getCommand("hud")).setExecutor((CommandExecutor)new HUDCommand());
        Objects.requireNonNull(this.getCommand("hud")).setTabCompleter((TabCompleter)new HUDCommand());
        Objects.requireNonNull(this.getCommand("directionhud")).setExecutor((CommandExecutor)new DHUDCommand());
        Objects.requireNonNull(this.getCommand("directionhud")).setTabCompleter((TabCompleter)new DHUDCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new EventManager(), (Plugin)this);
        if (DirectionHUD.isFolia()) {
            GlobalRegionScheduler globalScheduler = this.getServer().getGlobalRegionScheduler();
            globalScheduler.runAtFixedRate((Plugin)this, scheduledTask -> LoopManager.tick(), 1L, 1L);
        } else {
            new BukkitRunnable(this){

                public void run() {
                    LoopManager.tick();
                }
            }.runTaskTimerAsynchronously((Plugin)this, 0L, 1L);
        }
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, PacketHelper.getChannel(Assets.packets.INITIALIZATION), (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, PacketHelper.getChannel(Assets.packets.PLAYER_DATA));
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, PacketHelper.getChannel(Assets.packets.HUD));
    }

    public void onDisable() {
        Events.serverEnd();
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull org.bukkit.entity.Player player, byte @NotNull [] message) {
        if ((double)DirectionHUD.getMCVersion() < 20.6) {
            return;
        }
        if (channel.equals(PacketHelper.getChannel(Assets.packets.INITIALIZATION))) {
            LOGGER.info("Received initialization packet from " + player.getName() + ", connecting to client.");
            Player dPlayer = new Player(player);
            DirectionHUD.getData().getClientPlayers().add(dPlayer);
            dPlayer.sendPDataPackets();
        }
    }

    public static float getMCVersion() {
        String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
        String last2 = version.substring(version.indexOf(".") + 1);
        return Float.parseFloat(last2);
    }

    private static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        pluginData = new PluginData(false, "#3b82f6", "#ffee35");
    }
}

