/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.utils.Player;

public class PacketHelper {
    public static String getChannel(Assets.packets packetType) {
        return "directionhud:" + packetType.getIdentifier();
    }

    public static void sendPacket(Player player, Assets.packets packetType, String data) {
        PacketByteBuffer buffer = new PacketByteBuffer();
        buffer.writeString(data);
        player.getPlayer().sendPluginMessage(DirectionHUD.getData().getPlugin(), PacketHelper.getChannel(packetType), buffer.asByteArray());
    }

    public static class PacketByteBuffer {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public void writeInt(int value) {
            while (true) {
                if ((value & 0xFFFFFF80) == 0) {
                    this.writeByte(value);
                    return;
                }
                this.writeByte(value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        public void writeString(String string) {
            this.writeByteArray(string.getBytes(StandardCharsets.UTF_8));
        }

        public void writeBytes(byte[] bytes) {
            this.outputStream.writeBytes(bytes);
        }

        public void writeByteArray(byte[] bytes) {
            this.writeInt(bytes.length);
            this.writeBytes(bytes);
        }

        public void writeByte(int value) {
            this.outputStream.write((byte)value);
        }

        public byte[] asByteArray() {
            return this.outputStream.toByteArray();
        }
    }
}

