/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Utl;

public class LangReader {
    private static final Map<String, String> defaultLangMap = new HashMap<String, String>();
    private static final Map<String, String> languageMap = new HashMap<String, String>();
    private final String translationKey;
    private final Object[] placeholders;

    public LangReader(String translationKey, Object ... placeholders) {
        this.translationKey = translationKey;
        this.placeholders = placeholders;
    }

    public CTxT getTxT() {
        String translated = LangReader.getLanguageValue(this.translationKey);
        if (this.placeholders != null && this.placeholders.length > 0) {
            translated = translated.replaceAll("\\\\\\\\", "\\\\");
            String regex = "%\\d*\\$?[dfs]";
            Matcher anyMatch = Pattern.compile(regex).matcher(translated);
            Matcher endMatch = Pattern.compile(regex + "$").matcher(translated);
            ArrayList<String> matches = new ArrayList<String>();
            while (anyMatch.find()) {
                String match = anyMatch.group();
                matches.add(match);
            }
            String[] parts = translated.split(regex);
            if (endMatch.find()) {
                String[] newParts = Arrays.copyOf(parts, parts.length + 1);
                newParts[parts.length] = "";
                parts = newParts;
            }
            if (parts.length > 1) {
                CTxT txt = CTxT.of("");
                int i = 0;
                for (String match : matches) {
                    int get = i;
                    if (match.contains("$")) {
                        match = match.substring(1, match.indexOf(36));
                        get = Integer.parseInt(match) - 1;
                    }
                    if (parts.length != i) {
                        txt.append(parts[i]);
                    }
                    txt.append(Utl.getTxTFromObj(this.placeholders[get]));
                    ++i;
                }
                if (parts.length != i) {
                    txt.append(parts[i]);
                }
                return CTxT.of(txt);
            }
        }
        return CTxT.of(translated);
    }

    public static LangReader of(String translationKey, Object ... placeholders) {
        return new LangReader(translationKey, placeholders);
    }

    public static void loadLanguageFile() {
        Type tToken = new TypeToken<Map<String, String>>(){}.getType();
        try {
            InputStreamReader selectionReader = new InputStreamReader(LangReader.getInputStream(false), StandardCharsets.UTF_8);
            languageMap.putAll((Map)new Gson().fromJson((Reader)selectionReader, tToken));
            InputStreamReader defaultReader = new InputStreamReader(LangReader.getInputStream(true), StandardCharsets.UTF_8);
            defaultLangMap.putAll((Map)new Gson().fromJson((Reader)defaultReader, tToken));
        }
        catch (Exception e) {
            DirectionHUD.LOGGER.info("ERROR WITH LANGUAGE FILE - PLEASE REPORT WITH THE ERROR LOG");
            DirectionHUD.LOGGER.info(e.getMessage());
        }
    }

    private static InputStream getInputStream(boolean english) {
        ClassLoader classLoader = DirectionHUD.class.getClassLoader();
        String lang = FileData.getConfig().getLang();
        String[] paths = new String[]{DirectionHUD.getData().getConfigDirectory() + "lang/" + lang + ".json", "assets/directionhud/lang/" + lang + ".json", "assets/directionhud/lang/en_us.json"};
        if (english) {
            paths = new String[]{"assets/directionhud/lang/en_us.json"};
        }
        for (String path : paths) {
            InputStream inputStream = classLoader.getResourceAsStream(path);
            if (inputStream == null) continue;
            return inputStream;
        }
        throw new IllegalArgumentException("CANT LOAD THE LANGUAGE FILE. DIRECTIONHUD WILL BREAK.");
    }

    public static String getLanguageValue(String key) {
        return languageMap.getOrDefault(key, defaultLangMap.getOrDefault(key, key));
    }
}

