/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.dimension;

import com.google.gson.annotations.SerializedName;

public class DimensionEntry {
    @SerializedName(value="id")
    private String id = "";
    @SerializedName(value="name")
    private String name = "";
    @SerializedName(value="color")
    private String color = "";
    @SerializedName(value="time")
    private Time time = new Time();

    public DimensionEntry() {
    }

    public DimensionEntry(String id, String name, String color2, Time time) {
        this.id = id;
        this.name = name;
        this.color = color2;
        this.time = time;
    }

    public DimensionEntry(DimensionEntry dimensionEntry) {
        this.id = dimensionEntry.id;
        this.name = dimensionEntry.name;
        this.color = dimensionEntry.color;
        this.time = new Time(dimensionEntry.time);
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color2) {
        this.color = color2;
    }

    public static class Time {
        @SerializedName(value="enabled")
        private Boolean enabled = false;
        @SerializedName(value="weather")
        private Weather weather = new Weather();

        public Time() {
        }

        public Time(Boolean enabled) {
            this.enabled = enabled;
        }

        public Time(Weather weather) {
            this.enabled = true;
            this.weather = weather;
        }

        public Time(Time time) {
            this.enabled = time.enabled;
            this.weather = new Weather(time.weather);
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Weather getWeather() {
            return this.weather;
        }

        public static class Weather {
            @SerializedName(value="enabled")
            private Boolean enabled = false;
            @SerializedName(value="night-ticks")
            private NightTicks nightTicks;
            @SerializedName(value="icons")
            private Icons icons;

            public Weather() {
            }

            public Weather(NightTicks nightTicks, Icons icons) {
                this.icons = icons;
                this.nightTicks = nightTicks;
                this.enabled = true;
            }

            public Weather(Weather weather) {
                this.enabled = weather.enabled;
                this.nightTicks = weather.nightTicks;
                this.icons = weather.icons;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public NightTicks getNightTicks() {
                return this.nightTicks;
            }

            public Icons getIcons() {
                return this.icons;
            }

            public record Icons(String day, String night, String storm, String thunderstorm) {
                public static Icons defaultIcons() {
                    return new Icons("\u2600", "\u263d", "\ud83c\udf27", "\u26a1");
                }
            }

            public record NightTicks(TimePair normal, TimePair storm, TimePair thunderstorm) {
            }
        }

        public record TimePair(Integer startTick, Integer endTick) {
            @Override
            public String toString() {
                return "(Start tick: " + this.startTick + ", End tick: " + this.endTick + ")";
            }
        }
    }
}

