/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.ModuleManager;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSetting;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandlerRegistry;
import one.oth3r.directionhud.common.utils.ActionResult;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;

public abstract class BaseModule
implements Cloneable {
    @SerializedName(value="module")
    protected final Module moduleType;
    @SerializedName(value="order")
    protected Integer order;
    @SerializedName(value="state")
    protected boolean state;
    @SerializedName(value="settings")
    protected List<ModuleSetting<?>> settings = new ArrayList();

    public BaseModule(Module moduleType) {
        this.moduleType = moduleType;
    }

    public BaseModule(Module moduleType, Integer order, boolean state) {
        this.moduleType = moduleType;
        this.order = order;
        this.state = state;
    }

    public Integer getOrder() {
        return this.order;
    }

    public <V> void registerSetting(String settingID, V defaultValue, ModuleSettingHandler<V> validator) {
        this.settings.add(new ModuleSetting<V>(settingID, defaultValue, validator));
        ModuleSettingHandlerRegistry.registerValidator(settingID, validator);
    }

    public boolean hasSetting(String settingID) {
        return this.settings.stream().anyMatch(m -> m.getId().equals(settingID));
    }

    public <V> ActionResult setSetting(String settingID, String strValue) {
        Lang LANG = ModuleManager.Setting.LANG;
        if (this.hasSetting(settingID)) {
            ModuleSetting<V> setting = this.getSetting(settingID);
            try {
                V newValue = setting.getValidator().convert(strValue);
                boolean status = setting.setValue(newValue);
                if (status) {
                    return new ActionResult(true, setting.getDisplay().getSetMsg(setting.getValue().toString()));
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                return new ActionResult(false, LANG.error("invalid.setting_value", new CTxT(settingID).color(CUtl.s())));
            }
        }
        return new ActionResult(false, LANG.error(this.settings.isEmpty() ? "no_settings" : "invalid", this.moduleType.getCTxT()));
    }

    public <V> V getSettingValue(String settingID) {
        ModuleSetting<V> setting = this.getSetting(settingID);
        if (setting == null) {
            return null;
        }
        return setting.getValue();
    }

    public <V> ModuleSetting<V> getSetting(String settingID) {
        ModuleSetting setting = this.settings.stream().filter(moduleSetting -> moduleSetting.getId().equals(settingID)).findFirst().orElse(null);
        if (setting == null) {
            return null;
        }
        return setting;
    }

    public boolean hasSettings() {
        return !this.settings.isEmpty();
    }

    public List<ModuleSetting<?>> getSettings() {
        return new ArrayList(this.settings);
    }

    public void removeDuplicateSettings() {
        Collection<ModuleSetting> fixedSettings = this.settings.stream().collect(Collectors.toMap(ModuleSetting::getId, obj -> obj, (existing, duplicate) -> existing)).values();
        this.settings.clear();
        this.settings.addAll(fixedSettings);
    }

    protected String[] getSettingOrder() {
        return new String[0];
    }

    public List<ModuleSetting<?>> getOrderedSettings() {
        String[] order = this.getSettingOrder();
        if (order.length == 0) {
            return new ArrayList(this.settings);
        }
        ArrayList ordered = new ArrayList();
        for (String id2 : order) {
            ModuleSetting setting = this.getSetting(id2);
            if (setting == null) continue;
            ordered.add(setting);
        }
        for (ModuleSetting moduleSetting : this.settings) {
            if (!Arrays.stream(order).noneMatch(id -> id.equals(entry.getId()))) continue;
            ordered.add(moduleSetting);
        }
        return ordered;
    }

    public CTxT getSettingButtons() {
        CTxT out = new CTxT();
        List<ModuleSetting<?>> settingList = this.getOrderedSettings();
        for (int i = 0; i < settingList.size(); ++i) {
            ModuleSetting<?> setting = settingList.get(i);
            out.append(setting.getDisplay().getButton(setting.getValue().toString()));
            if (i >= settingList.size() - 1) continue;
            out.append(" ");
        }
        return out;
    }

    public void reassignValidators() {
        for (ModuleSetting moduleSetting : this.settings) {
            ModuleSettingHandler validator = ModuleSettingHandlerRegistry.getHandler(moduleSetting.getId());
            if (validator == null) continue;
            moduleSetting.setValidator(validator);
        }
    }

    public String[] getSettingIDs() {
        return (String[])this.settings.stream().map(ModuleSetting::getId).toArray(String[]::new);
    }

    public abstract DisplaySettings getDisplaySettings();

    public void setOrder(Integer order) {
        this.order = order;
    }

    public boolean isEnabled() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public Module getModuleType() {
        return this.moduleType;
    }

    public String toString() {
        return this.moduleType.getName();
    }

    public String getDisplayString(Object ... args) {
        if (!this.moduleType.verifyDisplayArguments(Arrays.stream(args).toList())) {
            throw new IllegalArgumentException("Invalid display arguments for module: " + this.moduleType.getName());
        }
        return this.display(args);
    }

    public CTxT getDisplayTxT(Player player, Object ... args) {
        return CUtl.parse(player, this.getDisplayString(args));
    }

    protected abstract String display(Object ... var1);

    public static Optional<BaseModule> findInArrayList(ArrayList<BaseModule> modules2, Module moduleType) {
        return modules2.stream().filter(baseModule -> baseModule.getModuleType().equals((Object)moduleType)).findFirst();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseModule that = (BaseModule)o;
        return this.state == that.state && this.moduleType == that.moduleType && Objects.equals(this.order, that.order) && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.moduleType, this.order, this.state, this.settings});
    }

    public BaseModule clone() {
        try {
            BaseModule clone = (BaseModule)super.clone();
            clone.settings = new ArrayList();
            for (ModuleSetting<?> entry : this.settings) {
                clone.settings.add((ModuleSetting<?>)entry.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

