/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.utils.ActionResult;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;

public class ModuleManager {
    public static final Lang LANG = new Lang("directionhud.hud.module.");
    public static final ActionResult INVALID_MODULE = new ActionResult(false, LANG.error("invalid", new Object[0]));
    public static final ActionResult DISABLED_MODULE = new ActionResult(false, State.LANG.error("disabled", new Object[0]));

    public static class State {
        public static final Lang LANG = new Lang("directionhud.hud.module.edit.");

        public static ActionResult disable(Player player, Module module) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return INVALID_MODULE;
            }
            Object mod = player.getPData().getHud().getModule(module);
            if (!((BaseModule)mod).isEnabled()) {
                return new ActionResult(false, LANG.error("state", module.getCTxT(), LANG.error("state.disabled", new Object[0])));
            }
            int order = ((BaseModule)mod).getOrder() == null ? 1 : ((BaseModule)mod).getOrder();
            ((BaseModule)mod).setOrder(null);
            ((BaseModule)mod).setState(false);
            Order.fixOrder(player.getPData().getHud().getModules());
            player.getPData().queueSave();
            CTxT msg = LANG.msg("state", LANG.msg("state.disabled", new Object[0]).color('c'), new CTxT(module.toString()).color(CUtl.s())).append(" ").append(((CTxT)((CTxT)((CTxT)new CTxT("\u23ee").color("#ff9500")).btn(true)).click(1, "/hud modules enable " + module.getName() + " " + order)).hover(((CTxT)Hud.modules.Disabled.LANG.hover("undo", new Object[0]).color("#ff9500")).append("\n").append(Hud.modules.Disabled.LANG.hover("undo.click", new CTxT(module.getName()).color(CUtl.s())))));
            return new ActionResult(true, msg, "module", Order.getModuleAt(player, order - 1).toString());
        }

        public static ActionResult enable(Player player, Module module, Integer order) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return INVALID_MODULE;
            }
            Object mod = player.getPData().getHud().getModule(module);
            if (((BaseModule)mod).isEnabled()) {
                return new ActionResult(false, LANG.error("state", module.getCTxT(), LANG.error("state.enabled", new Object[0])));
            }
            ArrayList<BaseModule> enabled = State.getEnabled(player);
            int page = Hud.modules.Disabled.getList(player).getPageOf((BaseModule)mod);
            ((BaseModule)mod).setState(true);
            if (order != null) {
                order = Math.max(Math.min(order, enabled.size() + 1), 1);
                ((BaseModule)mod).setOrder(order);
            } else {
                ((BaseModule)mod).setOrder(enabled.size() + 1);
            }
            player.getPData().queueSave();
            CTxT msg = LANG.msg("state", LANG.msg("state.enabled", new Object[0]).color('a'), new CTxT(module.toString()).color(CUtl.s())).append(" ").append(((CTxT)((CTxT)((CTxT)new CTxT("\u270e").btn(true)).color("#665dff")).click(1, "/hud modules edit " + module.getName())).hover(((CTxT)LANG.hover("edit", new Object[0]).color("#665dff")).append("\n").append(LANG.hover("edit.click", new CTxT(module.getName()).color(CUtl.s())))));
            return new ActionResult(true, msg, "page", String.valueOf(page));
        }

        public static ArrayList<BaseModule> getEnabled(Player player) {
            return player.getPCache().getHud().getModules().stream().filter(BaseModule::isEnabled).sorted(Comparator.comparingInt(BaseModule::getOrder)).collect(Collectors.toCollection(ArrayList::new));
        }

        public static ArrayList<BaseModule> getDisabled(Player player) {
            return player.getPCache().getHud().getModules().stream().filter(mod -> !mod.isEnabled()).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    public static class Setting {
        public static final Lang LANG = new Lang("directionhud.hud.module.setting.");

        public static ActionResult setSetting(Player player, Module module, String settingID, String value) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return INVALID_MODULE;
            }
            Object mod = player.getPData().getHud().getModule(module);
            if (!((BaseModule)mod).isEnabled()) {
                return DISABLED_MODULE;
            }
            ActionResult result = ((BaseModule)mod).setSetting(settingID, value);
            if (result.success()) {
                player.getPData().getHud().setModule((BaseModule)mod);
            }
            return result;
        }
    }

    public static class Order {
        public static final Lang LANG = new Lang("directionhud.hud.module.edit.");

        public static ActionResult move(Player player, Module module, int newOrder) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return INVALID_MODULE;
            }
            Object mod = player.getPData().getHud().getModule(module);
            if (!((BaseModule)mod).isEnabled()) {
                return DISABLED_MODULE;
            }
            ArrayList<BaseModule> list = player.getPData().getHud().getModules();
            ArrayList<BaseModule> enabled = State.getEnabled(player);
            newOrder = Math.max(1, Math.min(newOrder, enabled.size()));
            int oldOrder = ((BaseModule)mod).getOrder();
            if (oldOrder != newOrder) {
                int direction = oldOrder < newOrder ? -1 : 1;
                for (int i = newOrder; i != oldOrder; i += direction) {
                    ((BaseModule)player.getPData().getHud().getModule(enabled.get(i - 1).getModuleType())).setOrder(i + direction);
                }
            }
            ((BaseModule)mod).setOrder(newOrder);
            player.getPData().queueSave();
            int order = BaseModule.findInArrayList(list, module).orElse((BaseModule)player.getPData().getHud().getModule(module)).getOrder();
            CTxT msg = LANG.msg("order", CTxT.of(module.toString()).color(CUtl.s()), CTxT.of(String.valueOf(order)).color(CUtl.s()));
            return new ActionResult(true, msg);
        }

        public static void fixOrder(ArrayList<BaseModule> list) {
            Order.fixOrder(list, false);
        }

        public static void fixOrder(ArrayList<BaseModule> list, boolean getFactoryDefault) {
            ArrayList<BaseModule> defaultList = getFactoryDefault ? new PDHud().getModules() : PlayerData.getDefaults().getHud().getModules();
            Helper.removeDuplicateSubclasses(list);
            if (list.size() > defaultList.size()) {
                list.clear();
                list.addAll(defaultList);
                return;
            }
            defaultList.stream().filter(mod -> list.stream().noneMatch(module -> module.getClass().equals(mod.getClass()))).forEach(list::add);
            list.sort(Comparator.comparing(BaseModule::getOrder, Comparator.nullsLast(Comparator.naturalOrder())));
            Order.setOrder(list);
            list.forEach(BaseModule::removeDuplicateSettings);
        }

        public static void setOrder(ArrayList<BaseModule> list) {
            int orderIndex = 1;
            for (BaseModule baseModule : list) {
                if (baseModule.isEnabled()) {
                    baseModule.setOrder(orderIndex++);
                    continue;
                }
                baseModule.setOrder(null);
            }
        }

        public static Module getModuleAt(Player player, int order) {
            ArrayList<BaseModule> modules2 = State.getEnabled(player);
            if (modules2.isEmpty()) {
                return Module.UNKNOWN;
            }
            return modules2.get(Math.min(Math.max(order - 1, 0), modules2.size() - 1)).getModuleType();
        }
    }

    public static class Reset {
        public static ActionResult resetEverything(Player player) {
            player.getPData().getHud().setModules(PlayerData.getDefaults().getHud().getModules());
            return new ActionResult(true, LANG.msg("reset_all", CUtl.LANG.btn("all", new Object[0]).color('c')));
        }

        public static ActionResult resetModule(Player player, Module module) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return INVALID_MODULE;
            }
            Object mod = player.getPData().getHud().getModule(module);
            if (!((BaseModule)mod).hasSettings()) {
                return new ActionResult(false, Setting.LANG.error("no_settings", new CTxT(module.getName()).color(CUtl.s())));
            }
            if (!Reset.canResetSettings(mod)) {
                return new ActionResult(false, LANG.error("reset.already_reset", new CTxT(module.getName()).color(CUtl.s())));
            }
            BaseModule resetModule = ((BaseModule)PlayerData.getDefaults().getHud().getModule(module)).clone();
            resetModule.setOrder(((BaseModule)mod).getOrder());
            resetModule.setState(((BaseModule)mod).isEnabled());
            player.getPData().getHud().setModule(resetModule);
            return new ActionResult(true, LANG.msg("reset", CTxT.of(module.toString()).color(CUtl.s())));
        }

        public static boolean canResetSettings(BaseModule module) {
            Object defaultModule = PlayerData.getDefaults().getHud().getModule(module.getModuleType());
            return !((BaseModule)defaultModule).getSettings().equals(module.getSettings());
        }

        public static boolean canReset(BaseModule module) {
            Object defaultModule = PlayerData.getDefaults().getHud().getModule(module.getModuleType());
            return !((BaseModule)defaultModule).equals(module);
        }
    }
}

