/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.modules;

import java.text.DecimalFormat;
import java.util.Objects;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingButtonDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingType;
import one.oth3r.directionhud.common.utils.Helper;

public class ModuleAngle
extends BaseModule {
    public static final String displayID = "angle_display";
    public static final String DISPLAY_YAW = "yaw";
    public static final String DISPLAY_PITCH = "pitch";
    public static final String DISPLAY_BOTH = "both";

    public ModuleAngle() {
        super(Module.ANGLE);
    }

    public ModuleAngle(Integer order, boolean state, Display display) {
        super(Module.ANGLE, order, state);
        this.registerSetting(displayID, display, new ModuleSettingHandler<Display>(this){

            @Override
            public boolean isValid(Display value) {
                return Objects.nonNull((Object)value);
            }

            @Override
            public Display convert(String value) throws IllegalArgumentException {
                return Display.valueOf(value);
            }

            @Override
            public ModuleSettingDisplay getSettingDisplay() {
                return new ModuleSettingDisplay(Module.ANGLE, ModuleAngle.displayID, ModuleSettingType.ENUM_SWITCH, true, new ModuleSettingButtonDisplay(true).addMapping(ModuleAngle.DISPLAY_YAW, "\u2b0c").addMapping(ModuleAngle.DISPLAY_PITCH, "\u2b0d").addMapping(ModuleAngle.DISPLAY_BOTH, "\u2b0c\u2b0d"));
            }
        });
    }

    @Override
    protected String display(Object ... args) {
        DecimalFormat df = new DecimalFormat("0.0");
        String y = df.format(args[0]);
        String p = df.format(args[1]);
        return switch (Helper.Enums.get(this.getSettingValue(displayID), Display.class).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> DisplayRegistry.getFormatted(this.moduleType, DISPLAY_YAW, y);
            case 1 -> DisplayRegistry.getFormatted(this.moduleType, DISPLAY_PITCH, p);
            case 2 -> DisplayRegistry.getFormatted(this.moduleType, DISPLAY_BOTH, y, p);
        };
    }

    @Override
    public DisplaySettings getDisplaySettings() {
        DisplaySettings display = new DisplaySettings();
        display.addDisplay(DISPLAY_YAW, "&2%s");
        display.addDisplay(DISPLAY_PITCH, "&2%s");
        display.addDisplay(DISPLAY_BOTH, "&2%s&1/&2%s");
        return display;
    }

    public static enum Display {
        yaw,
        pitch,
        both;

    }
}

