/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module.modules;

import java.util.Objects;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.display.DisplayRegistry;
import one.oth3r.directionhud.common.hud.module.display.DisplaySettings;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingButtonDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingDisplay;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingHandler;
import one.oth3r.directionhud.common.hud.module.setting.ModuleSettingType;
import one.oth3r.directionhud.common.utils.Helper;

public class ModuleLight
extends BaseModule {
    public static final String targetID = "light_target";
    public static final String displayID = "light_display";
    public static final String DISPLAY_SKY = "sky";
    public static final String DISPLAY_BLOCK = "block";
    public static final String DISPLAY_BOTH = "both";

    public ModuleLight() {
        super(Module.LIGHT);
    }

    public ModuleLight(Integer order, boolean state, Target target, Display display) {
        super(Module.LIGHT, order, state);
        this.registerSetting(targetID, target, new ModuleSettingHandler<Target>(this){

            @Override
            public boolean isValid(Target value) {
                return Objects.nonNull((Object)value);
            }

            @Override
            public Target convert(String value) throws IllegalArgumentException {
                return Target.valueOf(value);
            }

            @Override
            public ModuleSettingDisplay getSettingDisplay() {
                return new ModuleSettingDisplay(Module.LIGHT, ModuleLight.targetID, ModuleSettingType.ENUM_SWITCH, true, new ModuleSettingButtonDisplay(true).addMapping("eye", "\ud83d\udc41").addMapping("below", "\u2b07"));
            }
        });
        this.registerSetting(displayID, display, new ModuleSettingHandler<Display>(this){

            @Override
            public boolean isValid(Display value) {
                return Objects.nonNull((Object)value);
            }

            @Override
            public Display convert(String value) throws IllegalArgumentException {
                return Display.valueOf(value);
            }

            @Override
            public ModuleSettingDisplay getSettingDisplay() {
                return new ModuleSettingDisplay(Module.LIGHT, ModuleLight.displayID, ModuleSettingType.ENUM_SWITCH, false, new ModuleSettingButtonDisplay(true));
            }
        });
    }

    @Override
    protected String display(Object ... args) {
        if ((Integer)args[0] == -1) {
            args[0] = "-";
        }
        if ((Integer)args[1] == -1) {
            args[1] = "-";
        }
        return switch (Helper.Enums.get(this.getSettingValue(displayID), Display.class).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> DisplayRegistry.getFormatted(this.moduleType, DISPLAY_SKY, args[0]);
            case 1 -> DisplayRegistry.getFormatted(this.moduleType, DISPLAY_BLOCK, args[1]);
            case 2 -> DisplayRegistry.getFormatted(this.moduleType, DISPLAY_BOTH, args[0], args[1]);
        };
    }

    @Override
    public DisplaySettings getDisplaySettings() {
        DisplaySettings display = new DisplaySettings();
        display.addDisplay(DISPLAY_SKY, "&2%s&1&b\ud83d\udca1");
        display.addDisplay(DISPLAY_BLOCK, "&2%s&1&b\ud83d\udca1");
        display.addDisplay(DISPLAY_BOTH, "&2%s&1,&2%s&1&b\ud83d\udca1");
        return display;
    }

    public static enum Display {
        sky,
        block,
        both;

    }

    public static enum Target {
        eye,
        below;

    }
}

