/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

import java.util.HashMap;
import java.util.Map;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.utils.CTxT;

public record ActionResult(boolean success, CTxT message, Integer code, Map<String, String> extraSettings) {
    public ActionResult(boolean success, CTxT message) {
        this(success, message, null, Map.of());
    }

    public ActionResult(boolean success, CTxT message, Integer code, Map<String, String> extraSettings) {
        if (message == null) {
            throw new NullPointerException("message cannot be null!");
        }
        this.success = success;
        this.message = message;
        this.code = code;
        this.extraSettings = extraSettings != null ? Map.copyOf(extraSettings) : Map.of();
    }

    public ActionResult(boolean success, CTxT message, Map<String, String> extraSettings) {
        this(success, message, null, extraSettings);
    }

    public ActionResult(boolean success, CTxT message, Integer code) {
        this(success, message, code, Map.of());
    }

    public ActionResult(boolean success, CTxT message, String ... extraKeyPair) {
        this(success, message, null, ActionResult.convertToMap(extraKeyPair));
    }

    public ActionResult(boolean success, CTxT message, Integer code, String ... extraKeyPair) {
        this(success, message, code, ActionResult.convertToMap(extraKeyPair));
    }

    public CTxT getChatMessage() {
        CTxT msg = CUtl.tag();
        if (!this.success) {
            msg = CUtl.error();
        }
        msg.append(this.message);
        return msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    private static Map<String, String> convertToMap(String ... extraKeyPair) {
        if (extraKeyPair == null || extraKeyPair.length == 0) {
            return Map.of();
        }
        if (extraKeyPair.length % 2 != 0) {
            throw new IllegalArgumentException("Key-value pairs must have an even number of arguments");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < extraKeyPair.length; i += 2) {
            map.put(extraKeyPair[i], extraKeyPair[i + 1]);
        }
        return Map.copyOf(map);
    }
}

