/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.files.LangReader;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.HudColor;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.common.utils.Rainbow;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;

public class CUtl {
    public static final Lang LANG = new Lang("");
    public static final Lang DLANG = new Lang("directionhud.");

    public static CTxT tag() {
        return CTxT.of("").append((CTxT)((CTxT)CTxT.of("DirectionHUD").btn(true)).color(CUtl.p())).append(" ");
    }

    public static String p() {
        return DirectionHUD.getData().getPrimary();
    }

    public static String s() {
        return DirectionHUD.getData().getSecondary();
    }

    public static CTxT error(String key, Object ... args) {
        return CUtl.error().append(CUtl.getLangEntry("error." + key, args));
    }

    public static CTxT error() {
        return CUtl.tag().append((CTxT)CUtl.getLangEntry("msg.error", new Object[0]).color("#ff4646")).append(" ");
    }

    public static CTxT usage(String s) {
        return CUtl.tag().append((CTxT)CUtl.getLangEntry("msg.usage", new Object[0]).color("#ff8b38")).append(" ").append(s);
    }

    public static CTxT getLangEntry(String key, Object ... args) {
        if (DirectionHUD.getData().isClient()) {
            Object[] fixedArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                fixedArgs[i] = args[i] instanceof CTxT ? ((CTxT)args[i]).b() : args[i];
            }
            return Utl.getTranslation(key, fixedArgs);
        }
        return LangReader.of(key, args).getTxT();
    }

    public static String toggleColor(boolean button) {
        return button ? "#55FF55" : "#FF5555";
    }

    public static CTxT toggleTxT(boolean button) {
        return (CTxT)LANG.btn(button ? "on" : "off", new Object[0]).color(CUtl.toggleColor(button));
    }

    public static CTxT toggleBtn(boolean button, String cmd) {
        return (CTxT)((CTxT)((CTxT)LANG.btn(button ? "on" : "off", new Object[0]).btn(true)).color(button ? (char)'a' : 'c')).hover(LANG.hover("state", CUtl.toggleTxT(!button))).click(1, cmd + (button ? "off" : "on"));
    }

    public static CTxT makeLine(int length) {
        return (CTxT)CTxT.of("\n" + " ".repeat(Math.max(0, length))).strikethrough(true);
    }

    public static void confirmation(Player player, String command, String returnKey) {
        if (!((String)command).endsWith("confirm")) {
            command = (String)command + " confirm";
        }
        Object returnCmd = returnKey != null ? ((String)command).replaceFirst(returnKey, returnKey + "-r") : command;
        CTxT clickButton = (CTxT)((CTxT)((CTxT)DLANG.btn("click", new Object[0]).btn(true)).color(CUtl.s())).hover(((CTxT)DLANG.get("confirm.hover", new Object[0]).color(CUtl.s())).append("\n").append(new CTxT((String)command))).click(1, (String)returnCmd);
        CTxT line = CUtl.makeLine(55);
        CTxT msg = new CTxT(" ").append((CTxT)DLANG.get("confirm.ui", new Object[0]).color(CUtl.s())).append(line).append("\n ").append(DLANG.get("confirm.msg", new Object[0])).append("\n\n ").append(DLANG.get("confirm.msg.action", clickButton)).append("\n ").append((CTxT)((CTxT)new CTxT((String)command).color(CUtl.s())).click(2, (String)command)).append(line);
        player.sendMessage(msg);
    }

    public static CTxT parse(Player player, String input) {
        ArrayList<Character> selectors = new ArrayList<Character>(List.of(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('b'), Character.valueOf('i'), Character.valueOf('s'), Character.valueOf('u'), Character.valueOf('o'), Character.valueOf('r')));
        CTxT output = CTxT.of("");
        HudColor color2 = HudColor.PRIMARY;
        StringBuilder current = new StringBuilder();
        boolean bold = false;
        boolean italic = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        int i = 0;
        while (i < input.length()) {
            int ahead = i + 1;
            if (input.charAt(i) == '&' && ahead < input.length() && selectors.contains(Character.valueOf(input.charAt(ahead)))) {
                char code = input.charAt(ahead);
                output.append(CUtl.colorize(player, current.toString(), color2, bold, italic, strikethrough, underline, obfuscated));
                current.setLength(0);
                switch (code) {
                    case '1': {
                        color2 = HudColor.PRIMARY;
                        break;
                    }
                    case '2': {
                        color2 = HudColor.SECONDARY;
                        break;
                    }
                    case 'b': {
                        bold = true;
                        break;
                    }
                    case 'i': {
                        italic = true;
                        break;
                    }
                    case 's': {
                        strikethrough = true;
                        break;
                    }
                    case 'u': {
                        underline = true;
                        break;
                    }
                    case 'o': {
                        obfuscated = true;
                        break;
                    }
                    case 'r': {
                        bold = false;
                        italic = false;
                        strikethrough = false;
                        underline = false;
                        obfuscated = false;
                    }
                }
                i += 2;
                continue;
            }
            current.append(input.charAt(i));
            ++i;
        }
        output.append(CUtl.colorize(player, current.toString(), color2, bold, italic, strikethrough, underline, obfuscated));
        return output;
    }

    public static CTxT colorize(Player player, String text, HudColor color2, boolean bold, boolean italic, boolean strikethrough, boolean underline, boolean obfuscated) {
        Rainbow hudRainbow = player.getPCache().getRainbow(color2);
        CTxT build2 = Hud.color.addColor(player, new CTxT(text), color2, new Rainbow(hudRainbow));
        if (bold) {
            build2.bold(true);
        }
        if (italic) {
            build2.italic(true);
        }
        ((CTxT)((CTxT)build2.strikethrough(strikethrough)).underline(underline)).obfuscate(obfuscated);
        return build2;
    }

    public static class color {
        public static final List<String> DEFAULT_COLORS = List.of("#ff5757", "#d40000", "#900000", "#ffa562", "#ff9834", "#e77400", "#ffff86", "#ffff5b", "#f9c517", "#9aff9a", "#5dc836", "#396a30", "#8ddfff", "#0099ff", "#004995", "#a38cff", "#8c04dd", "#5c00a7", "#d9d9d9", "#808080", "#404040");

        public static String updateOld(String string, String defaultColor) {
            return switch (string) {
                case "red" -> "#FF5555";
                case "dark_red" -> "#AA0000";
                case "gold" -> "#FFAA00";
                case "yellow" -> "#FFFF55";
                case "green" -> "#55FF55";
                case "dark_green" -> "#00AA00";
                case "aqua" -> "#55FFFF";
                case "dark_aqua" -> "#00AAAA";
                case "blue" -> "#5555FF";
                case "dark_blue" -> "#0000AA";
                case "pink" -> "#FF55FF";
                case "purple" -> "#AA00AA";
                case "white" -> "#FFFFFF";
                case "gray" -> "#AAAAAA";
                case "dark_gray" -> "#555555";
                case "black" -> "#000000";
                default -> string.isEmpty() || string.charAt(0) != '#' ? color.format(defaultColor) : color.format(string);
            };
        }

        public static String format(String hex, String defaultColor) {
            String regex;
            Pattern pattern;
            Matcher matcher;
            if (hex == null) {
                return color.format(defaultColor);
            }
            if (((String)hex).length() == 6) {
                hex = "#" + (String)hex;
            }
            if (((String)hex).length() == 7 && (matcher = (pattern = Pattern.compile(regex = "^#([A-Fa-f0-9]{6})$")).matcher((CharSequence)hex)).matches()) {
                return ((String)hex).toLowerCase();
            }
            return color.format(defaultColor);
        }

        public static String format(String hex) {
            return color.format(hex, "#ffffff");
        }

        public static String format(char character) {
            return switch (character) {
                case 'c' -> "#ff5555";
                case 'e' -> "#FFFF55";
                case 'a' -> "#55ff55";
                case '7' -> "#AAAAAA";
                default -> "#FFFFFF";
            };
        }

        public static CTxT getBadge(String hex) {
            return (CTxT)CTxT.of("\u2588 " + color.format(hex).toUpperCase()).color(hex);
        }

        public static float[] HSB(String hex) {
            Color color2 = Color.decode(color.format(hex));
            int r = color2.getRed();
            int g = color2.getGreen();
            int b = color2.getBlue();
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            return hsb;
        }

        public static int[] RGB(String hex) {
            Color color2 = Color.decode(color.format(hex));
            int[] i = new int[]{color2.getRed(), color2.getGreen(), color2.getBlue()};
            return i;
        }

        public static String HSBtoHEX(float[] hsb) {
            Color color2 = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            return String.format("#%02x%02x%02x", color2.getRed(), color2.getGreen(), color2.getBlue());
        }

        public static String editHSB(int type, String hex, float change) {
            float[] hsb = color.HSB(hex);
            hsb[type] = Math.max(Math.min(hsb[type] + change, 1.0f), 0.0f);
            return color.HSBtoHEX(hsb);
        }

        public static String colorHandler(Player player, String color2) {
            return color.colorHandler(player, color2, "#ffffff");
        }

        public static String colorHandler(Player player, String color2, String defaultColor) {
            if (color2 != null) {
                if (color2.contains("preset-")) {
                    String name = color2.split("-")[1];
                    for (Helper.ColorPreset preset2 : player.getPData().getColorPresets()) {
                        if (!preset2.name().equals(name)) continue;
                        color2 = preset2.color();
                        break;
                    }
                }
                switch (color2.toLowerCase()) {
                    case "red": {
                        color2 = DEFAULT_COLORS.get(1);
                        break;
                    }
                    case "orange": {
                        color2 = DEFAULT_COLORS.get(4);
                        break;
                    }
                    case "yellow": {
                        color2 = DEFAULT_COLORS.get(7);
                        break;
                    }
                    case "green": {
                        color2 = DEFAULT_COLORS.get(10);
                        break;
                    }
                    case "blue": {
                        color2 = DEFAULT_COLORS.get(13);
                        break;
                    }
                    case "purple": {
                        color2 = DEFAULT_COLORS.get(16);
                        break;
                    }
                    case "gray": {
                        color2 = DEFAULT_COLORS.get(19);
                    }
                }
            }
            color2 = color.format(color2, defaultColor);
            return color2;
        }
    }

    public static class CButton {
        public static CTxT back(String cmd) {
            return ((CTxT)((CTxT)((CTxT)LANG.btn("back", new Object[0]).btn(true)).color("#ff9500")).click(1, cmd)).hover(((CTxT)CTxT.of(cmd).color("#ff9500")).append("\n").append(LANG.hover("back", new Object[0])));
        }
    }
}

