/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.utils;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;

public class BossBarManager {
    private final Map<Player, BossBar> bossBars = new HashMap<Player, BossBar>();

    public void addPlayer(Player player) {
        if (this.bossBars.get(player) == null) {
            BossBar bossBar = BossBar.bossBar((Component)Component.text((String)"DirectionHUD"), (float)1.0f, (BossBar.Color)BossBar.Color.WHITE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
            player.getPlayer().showBossBar(bossBar);
            this.bossBars.put(player, bossBar);
        }
    }

    public void removePlayer(Player player) {
        BossBar bossBar = this.bossBars.remove(player);
        if (bossBar != null) {
            player.getPlayer().hideBossBar(bossBar);
        }
    }

    public void display(Player player, CTxT hud) {
        if (!this.bossBars.containsKey(player)) {
            this.addPlayer(player);
        }
        BossBar bossBar = this.bossBars.get(player);
        bossBar.name((Component)hud.b());
        bossBar.color(Helper.Enums.get(player.getPCache().getHud().getSetting(Hud.Setting.bossbar__color), BossBar.Color.class));
        if (Destination.dest.get(player).hasXYZ() && ((Boolean)player.getPCache().getHud().getSetting(Hud.Setting.bossbar__distance)).booleanValue()) {
            int dist = Destination.dest.getDist(player);
            float progress = this.getProgress(dist, ((Integer)player.getPCache().getHud().getSetting(Hud.Setting.bossbar__distance_max)).intValue());
            bossBar.overlay(BossBar.Overlay.NOTCHED_10);
            if ((Integer)player.getPCache().getHud().getSetting(Hud.Setting.bossbar__distance_max) == 0) {
                progress = this.getProgress(dist, 1000.0);
                StringBuilder s = new StringBuilder();
                for (int i = 1; i < 5; ++i) {
                    if (dist > Integer.parseInt("750" + s.toString())) {
                        bossBar.overlay(BossBar.Overlay.NOTCHED_20);
                        progress = this.getProgress(dist, Integer.parseInt("2000" + s.toString()));
                    }
                    if (dist > Integer.parseInt("1750" + s.toString())) {
                        bossBar.overlay(BossBar.Overlay.NOTCHED_10);
                        progress = this.getProgress(dist, Integer.parseInt("10000" + s.toString()));
                    }
                    s.append("0");
                }
            }
            bossBar.progress(progress);
        } else {
            bossBar.progress(1.0f);
            bossBar.overlay(BossBar.Overlay.PROGRESS);
        }
    }

    private float getProgress(int current, double max) {
        double progress = (double)current / max;
        if ((double)current > max) {
            progress = 1.0;
        }
        progress = Math.max(Math.min(progress, 1.0), 0.0);
        progress = (progress - 1.0) * -1.0;
        return (float)progress;
    }
}

